/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easy_villagers.corelib.client.obj;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import de.maxhenkel.easy_villagers.corelib.client.obj.OBJModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.obj.OBJModel;

public class OBJLoader {
    private static Map<ResourceLocation, OBJModel.OBJModelData> modelCache = new HashMap<ResourceLocation, OBJModel.OBJModelData>();

    public static OBJModel.OBJModelData load(ResourceLocation model) {
        try {
            return OBJLoader.loadInternal(model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static OBJModel.OBJModelData loadInternal(ResourceLocation model) throws IOException {
        String[] line;
        if (modelCache.containsKey(model)) {
            return modelCache.get(model);
        }
        Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(model);
        LineReader reader = new LineReader(resource);
        ArrayList positions = Lists.newArrayList();
        ArrayList texCoords = Lists.newArrayList();
        ArrayList normals = Lists.newArrayList();
        ArrayList faces = Lists.newArrayList();
        while ((line = reader.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "v": {
                    positions.add(OBJModel.parseVector4To3((String[])line));
                    break;
                }
                case "vt": {
                    Vec2 vec2f = OBJModel.parseVector2((String[])line);
                    texCoords.add(new Vec2(vec2f.f_82470_, 1.0f - vec2f.f_82471_));
                    break;
                }
                case "vn": {
                    normals.add(OBJModel.parseVector3((String[])line));
                    break;
                }
                case "f": {
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? positions.size() + vertex[0] : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? texCoords.size() + vertex[1] : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? normals.size() + vertex[2] : vertex[2] - 1;
                            }
                        }
                        vertices[i] = vertex;
                    }
                    faces.add(vertices);
                }
            }
        }
        OBJModel.OBJModelData obj = new OBJModel.OBJModelData(positions, texCoords, normals, faces);
        modelCache.put(model, obj);
        return obj;
    }

    private static class LineReader
    implements AutoCloseable {
        private InputStreamReader lineStream;
        private BufferedReader lineReader;

        public LineReader(Resource resource) {
            this.lineStream = new InputStreamReader(resource.m_6679_(), Charsets.UTF_8);
            this.lineReader = new BufferedReader(this.lineStream);
        }

        @Nullable
        public String[] readAndSplitLine(boolean ignoreEmptyLines) throws IOException {
            do {
                String currentLine;
                if ((currentLine = this.lineReader.readLine()) == null) {
                    return null;
                }
                ArrayList lineParts = new ArrayList();
                if (currentLine.startsWith("#")) {
                    currentLine = "";
                }
                if (currentLine.length() > 0) {
                    boolean hasContinuation;
                    do {
                        String tmp = (hasContinuation = currentLine.endsWith("\\")) ? currentLine.substring(0, currentLine.length() - 1) : currentLine;
                        Arrays.stream(tmp.split("[\t ]+")).filter(s -> !Strings.isNullOrEmpty((String)s)).forEach(lineParts::add);
                    } while ((!hasContinuation || (currentLine = this.lineReader.readLine()) != null && currentLine.length() != 0 && !currentLine.startsWith("#")) && hasContinuation);
                }
                if (lineParts.size() <= 0) continue;
                return lineParts.toArray(new String[0]);
            } while (ignoreEmptyLines);
            return new String[0];
        }

        @Override
        public void close() throws Exception {
            this.lineReader.close();
            this.lineStream.close();
        }
    }
}

