/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import gg.essential.loader.stage2.util.DelegatingJarMetadata;
import gg.essential.loader.stage2.util.SortedJarOrPathList;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelfRenamingJarMetadata
extends DelegatingJarMetadata {
    private static final Logger LOGGER = LogManager.getLogger(SelfRenamingJarMetadata.class);
    private static final ThreadLocal<Boolean> RE_ENTRANCE_LOCK = ThreadLocal.withInitial(() -> false);
    private final SecureJar secureJar;
    private final IModuleLayerManager.Layer layer;

    public SelfRenamingJarMetadata(SecureJar secureJar, Path path, IModuleLayerManager.Layer layer) {
        super(JarMetadata.from((SecureJar)secureJar, (Path[])new Path[]{path}));
        this.secureJar = secureJar;
        this.layer = layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String name() {
        if (RE_ENTRANCE_LOCK.get().booleanValue()) {
            throw new SelfRenamingReEntranceException();
        }
        RE_ENTRANCE_LOCK.set(true);
        String defaultName = this.delegate.name();
        Set ourPackages = this.secureJar.getPackages();
        try {
            for (SecureJar otherJar : this.getLayerJars()) {
                String otherModuleName;
                try {
                    otherModuleName = otherJar.name();
                }
                catch (SelfRenamingReEntranceException ignored) {
                    continue;
                }
                if (!otherJar.getPackages().stream().anyMatch(ourPackages::contains)) continue;
                LOGGER.debug("Found existing module with name {}, renaming {} to match.", (Object)otherModuleName, (Object)defaultName);
                String string = otherModuleName;
                return string;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception occurred while trying to self-rename module " + defaultName + ": ", e);
        }
        finally {
            RE_ENTRANCE_LOCK.set(false);
        }
        LOGGER.debug("Did not find any existing modules to rename {}.", (Object)defaultName);
        return defaultName;
    }

    private List<Object> getLayerElements() throws Throwable {
        IModuleLayerManager layerManager = (IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow();
        Field layersField = layerManager.getClass().getDeclaredField("layers");
        layersField.setAccessible(true);
        return (List)((EnumMap)layersField.get(layerManager)).get(this.layer);
    }

    private List<SecureJar> getLayerJars() throws Throwable {
        ArrayList<SecureJar> jars = new ArrayList<SecureJar>();
        for (Object pathOrJar : this.getLayerElements()) {
            SecureJar jar = SortedJarOrPathList.getJar(pathOrJar);
            if (jar == null) continue;
            jars.add(jar);
        }
        return jars;
    }

    private static class SelfRenamingReEntranceException
    extends RuntimeException {
        private SelfRenamingReEntranceException() {
        }
    }
}

