/*
 * Decompiled with CFR 0.152.
 */
package net.hadrus.alcocraft.effects;

import net.hadrus.alcocraft.effects.AttractEffect;
import net.hadrus.alcocraft.effects.FlightEffect;
import net.hadrus.alcocraft.effects.FreezeEffect;
import net.hadrus.alcocraft.effects.PhantomEffect;
import net.hadrus.alcocraft.effects.WitherEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AlcoEffects {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"alcocraft");
    public static final RegistryObject<MobEffect> FLIGHT = EFFECTS.register("flight", () -> new FlightEffect(MobEffectCategory.BENEFICIAL, AlcoEffects.rawColorFromRGB(199, 183, 255)));
    public static final RegistryObject<MobEffect> FREEZE = EFFECTS.register("freeze", () -> new FreezeEffect(MobEffectCategory.BENEFICIAL, AlcoEffects.rawColorFromRGB(143, 181, 246)));
    public static final RegistryObject<MobEffect> PHANTOM = EFFECTS.register("phantom", () -> new PhantomEffect(MobEffectCategory.BENEFICIAL, AlcoEffects.rawColorFromRGB(58, 70, 123)));
    public static final RegistryObject<MobEffect> ATTRACT = EFFECTS.register("attract", () -> new AttractEffect(MobEffectCategory.BENEFICIAL, AlcoEffects.rawColorFromRGB(170, 14, 1)));
    public static final RegistryObject<MobEffect> WITHER = EFFECTS.register("wither", () -> new WitherEffect(MobEffectCategory.BENEFICIAL, AlcoEffects.rawColorFromRGB(29, 5, 3)));

    public static void register(IEventBus eventBus) {
        EFFECTS.register(eventBus);
    }

    public static int rawColorFromRGB(int red, int green, int blue) {
        int rgb = Math.max(Math.min(255, red), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, green), 0);
        rgb = (rgb << 8) + Math.max(Math.min(255, blue), 0);
        return rgb;
    }
}

