/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.gui.ContainerCar;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class GuiCar
extends ScreenBase<ContainerCar> {
    private static final ResourceLocation CAR_GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car.png");
    private static final int fontColor = 0x404040;
    private Inventory playerInv;
    private EntityCarInventoryBase car;

    public GuiCar(ContainerCar containerCar, Inventory playerInv, Component title) {
        super(CAR_GUI_TEXTURE, containerCar, playerInv, title);
        this.playerInv = playerInv;
        this.car = containerCar.getCar();
        this.f_97726_ = 176;
        this.f_97727_ = 248;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92877_(matrixStack, this.car.m_5446_().m_7532_(), 7.0f, 87.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.playerInv.m_5446_().m_7532_(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.getFuelString().m_7532_(), 7.0f, 9.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.getDamageString().m_7532_(), 7.0f, 35.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.getBatteryString().m_7532_(), 95.0f, 9.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.getTempString().m_7532_(), 95.0f, 35.0f, 0x404040);
    }

    public float getFuelPercent() {
        float fuelPerc = (float)this.car.getFuelAmount() / (float)this.car.getMaxFuel() * 100.0f;
        return MathUtils.round(fuelPerc, 2);
    }

    public int getBatteryPercent() {
        return (int)(this.car.getBatteryPercentage() * 100.0f);
    }

    public float getTemperatureCelsius() {
        return MathUtils.round(this.car.getTemperature(), 2);
    }

    public float getTemperatureFarenheit() {
        return MathUtils.round(this.car.getTemperature() * 1.8f + 32.0f, 2);
    }

    public float getTemperaturePercent() {
        float temp = this.car.getTemperature();
        if (temp > 100.0f) {
            temp = 100.0f;
        }
        if (temp < 0.0f) {
            temp = 0.0f;
        }
        return temp / 100.0f;
    }

    public float getDamagePercent() {
        float dmg = this.car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    public Component getFuelString() {
        return new TranslatableComponent("gui.car_fuel", new Object[]{String.valueOf(this.getFuelPercent())});
    }

    public Component getDamageString() {
        return new TranslatableComponent("gui.car_damage", new Object[]{String.valueOf(this.getDamagePercent())});
    }

    public Component getBatteryString() {
        return new TranslatableComponent("gui.car_battery", new Object[]{String.valueOf(this.getBatteryPercent())});
    }

    public Component getTempString() {
        if (((Boolean)Main.CLIENT_CONFIG.tempInFarenheit.get()).booleanValue()) {
            return new TranslatableComponent("gui.car_temperature_farenheit", new Object[]{String.valueOf(this.getTemperatureFarenheit())});
        }
        return new TranslatableComponent("gui.car_temperature_celsius", new Object[]{String.valueOf(this.getTemperatureCelsius())});
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawFuel(matrixStack, this.getFuelPercent());
        this.drawDamage(matrixStack, 100.0f - this.getDamagePercent());
        this.drawBattery(matrixStack, this.car.getBatteryPercentage());
        this.drawTemp(matrixStack, this.getTemperaturePercent());
    }

    public void drawFuel(PoseStack matrixStack, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 8, j + 20, 176, 0, scaled, 10);
    }

    public void drawDamage(PoseStack matrixStack, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)((double)(72.0f * percent) / 100.0);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 8, j + 46, 176, 10, scaled, 10);
    }

    public void drawTemp(PoseStack matrixStack, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 96, j + 46, 176, 30, scaled, 10);
    }

    public void drawBattery(PoseStack matrixStack, float percent) {
        percent = Math.min(100.0f, percent);
        int scaled = (int)(72.0f * percent);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 96, j + 20, 176, 20, scaled, 10);
    }
}

