/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.saturn.common.config;

import com.abdelaziz.saturn.common.Saturn;
import com.abdelaziz.saturn.common.config.Option;
import com.abdelaziz.saturn.common.config.SaturnOptions;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigBuilder {
    private static CommentedFileConfig fileConfig;

    public static void build() {
        File file = new File(String.valueOf(FMLPaths.CONFIGDIR.get().resolve("saturn-optimizations.toml")));
        Saturn.getLogger().info("Loaded Saturn config file with {} configurable options", (Object)SaturnOptions.getOptions().size());
        Config.setInsertionOrderPreserved((boolean)true);
        ConfigSpec config = new ConfigSpec();
        for (Option option : SaturnOptions.getOptions()) {
            config.define(option.name(), (Object)option.value());
        }
        fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((File)file).sync().build();
        fileConfig.load();
        for (Option option : SaturnOptions.getOptions()) {
            fileConfig.setComment(option.name(), option.description());
        }
        config.correct((Config)fileConfig);
        fileConfig.save();
        fileConfig.close();
    }

    public static CommentedFileConfig getFileConfig() {
        return fileConfig;
    }
}

