/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.entities;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlockEntities;
import noobanidus.mods.lootr.util.ChestUtil;

public class LootrShulkerBlockEntity
extends RandomizableContainerBlockEntity
implements ILootBlockEntity {
    public Set<UUID> openers = new HashSet<UUID>();
    protected ResourceLocation savedLootTable = null;
    protected long seed = -1L;
    protected UUID tileId;
    protected boolean opened;
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private int openCount;
    private ShulkerBoxBlockEntity.AnimationStatus animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    @Nullable
    private final DyeColor color = DyeColor.YELLOW;
    private boolean savingToItem = false;

    public LootrShulkerBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public LootrShulkerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        this(ModBlockEntities.SPECIAL_LOOT_SHULKER, pWorldPosition, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, LootrShulkerBlockEntity pBlockEntity) {
        pBlockEntity.updateAnimation(pLevel, pPos, pState);
    }

    private void updateAnimation(Level pLevel, BlockPos pPos, BlockState pState) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                this.moveCollidedEntities(pLevel, pPos, pState);
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
                this.progress = 0.0f;
                LootrShulkerBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public ShulkerBoxBlockEntity.AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState pState) {
        return Shulker.m_149790_((Direction)((Direction)pState.m_61143_((Property)ShulkerBoxBlock.f_56183_)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction;
        AABB aabb;
        List list;
        if (pState.m_60734_() instanceof ShulkerBoxBlock && !(list = pLevel.m_45933_(null, aabb = Shulker.m_149793_((Direction)(direction = (Direction)pState.m_61143_((Property)ShulkerBoxBlock.f_56183_)), (float)this.progressOld, (float)this.progress).m_82338_(pPos))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                entity.m_6478_(MoverType.SHULKER_BOX, new Vec3((aabb.m_82362_() + 0.01) * (double)direction.m_122429_(), (aabb.m_82376_() + 0.01) * (double)direction.m_122430_(), (aabb.m_82385_() + 0.01) * (double)direction.m_122431_()));
            }
        }
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7531_(int pId, int pType) {
        if (pId == 1) {
            this.openCount = pType;
            if (pType == 0) {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSING;
                LootrShulkerBlockEntity.doNeighborUpdates(this.m_58904_(), this.f_58858_, this.m_58900_());
            }
            if (pType == 1) {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENING;
                LootrShulkerBlockEntity.doNeighborUpdates(this.m_58904_(), this.f_58858_, this.m_58900_());
            }
            return true;
        }
        return super.m_7531_(pId, pType);
    }

    private static void doNeighborUpdates(Level pLevel, BlockPos pPos, BlockState pState) {
        pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
    }

    public void m_5856_(Player pPlayer) {
        if (!pPlayer.m_5833_()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount == 1) {
                this.f_58857_.m_142346_((Entity)pPlayer, GameEvent.f_157803_, this.f_58858_);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12409_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!pPlayer.m_5833_()) {
            --this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.f_58857_.m_142346_((Entity)pPlayer, GameEvent.f_157802_, this.f_58858_);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12408_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
            }
            this.openers.add(pPlayer.m_142081_());
            this.m_6596_();
            this.updatePacketViaState();
        }
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.shulkerBox");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return null;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.m_128461_("specialLootChest_table"));
        }
        if (compound.m_128425_("specialLootChest_seed", 4)) {
            this.seed = compound.m_128454_("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.m_128425_("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.m_128461_("LootTable"));
            if (this.seed == 0L && compound.m_128425_("LootTableSeed", 4)) {
                this.seed = compound.m_128454_("LootTableSeed");
            }
        }
        if (compound.m_128403_("tileId")) {
            this.tileId = compound.m_128342_("tileId");
        }
        if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.m_128441_("LootrOpeners")) {
            ListTag openers = compound.m_128437_("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.m_129233_((Tag)item));
            }
        }
        super.m_142466_(compound);
    }

    public void m_187476_(ItemStack itemstack) {
        this.savingToItem = true;
        super.m_187476_(itemstack);
        this.savingToItem = false;
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.savedLootTable != null) {
            compound.m_128359_("specialLootChest_table", this.savedLootTable.toString());
            compound.m_128359_("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.m_128356_("specialLootChest_seed", this.seed);
            compound.m_128356_("LootTableSeed", this.seed);
        }
        if (!LootrAPI.shouldDiscard() && !this.savingToItem) {
            compound.m_128362_("tileId", this.getTileId());
            ListTag list = new ListTag();
            for (UUID opener : this.openers) {
                list.add((Object)NbtUtils.m_129226_((UUID)opener));
            }
            compound.m_128365_("LootrOpeners", (Tag)list);
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.itemStacks;
    }

    protected void m_6520_(NonNullList<ItemStack> pItems) {
        this.itemStacks = pItems;
    }

    public float getProgress(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isClosed() {
        return this.animationStatus == ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public BlockPos getPosition() {
        return this.m_58899_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    @Override
    public void updatePacketViaState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 8);
        }
    }

    @Override
    public void setOpened(boolean opened) {
        this.opened = true;
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag result = super.m_5995_();
        this.m_183515_(result);
        return result;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void m_59640_(@Nullable Player player) {
    }

    @Override
    public void unpackLootTable(Player player, Container inventory, ResourceLocation overrideTable, long seed) {
        if (this.f_58857_ != null && this.savedLootTable != null && this.f_58857_.m_142572_() != null) {
            LootTable loottable = this.f_58857_.m_142572_().m_129898_().m_79217_(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.f_79105_) {
                LootrAPI.LOG.error("Unable to fill loot shulker in " + this.f_58857_.m_46472_().m_135782_() + " at " + this.f_58858_ + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.m_5661_(ChestUtil.getInvalidTable(overrideTable != null ? overrideTable : this.savedLootTable), false);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, overrideTable != null ? overrideTable : this.f_59605_);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78965_((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed));
            if (player != null) {
                builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_79123_(inventory, builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    public void m_59626_(ResourceLocation lootTableIn, long seedIn) {
        super.m_59626_(lootTableIn, seedIn);
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
    }
}

