/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.api;

import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.CustomArmorBar;
import java.util.function.Function;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;

public class ArmorBarBuilder {
    private ArmorItem[] armor;
    private Function<ItemStack, ArmorBarRenderManager> predicate;

    public ArmorBarBuilder armor(ArmorItem ... armorItem) {
        try {
            this.armor = armorItem;
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException("This is not ArmorItem");
        }
    }

    public ArmorBarBuilder render(Function<ItemStack, ArmorBarRenderManager> renderManager) {
        this.predicate = renderManager;
        return this;
    }

    public void register() {
        try {
            CustomArmorBar armorBar = new CustomArmorBar(this.predicate);
            for (ArmorItem armorItem : this.armor) {
                DetailArmorBarAPI.armorList.put(armorItem, armorBar);
            }
            if (this.armor.length != 0 && this.armor[0].getRegistryName() != null) {
                DetailArmorBar.LOGGER.log(Level.INFO, "Successfully registered '" + this.armor[0].getRegistryName().toString() + (String)(this.armor.length > 1 ? "' and " + (this.armor.length - 1) + " more items" : "'") + "!");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Not all items have been initialized");
        }
    }
}

