/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab;

import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.ItemBarRenderManager;
import com.redlimerl.detailab.api.render.TextureOffset;
import com.redlimerl.detailab.config.DABForgeConfig;
import com.redlimerl.detailab.config.DetailArmorBarConfig;
import com.redlimerl.detailab.screen.OptionsScreen;
import java.awt.Color;
import java.io.File;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="detailab")
public class DetailArmorBar {
    public static final Logger LOGGER = LogManager.getLogger((String)"DetailArmorBar");
    public static final String MOD_ID = "detailab";
    public static final ResourceLocation GUI_ARMOR_BAR = new ResourceLocation("detailab", "textures/armor_bar.png");
    private static final String[] compatibilityMods = new String[]{"healthoverlay"};
    private static DetailArmorBarConfig config = null;

    public DetailArmorBar() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.onInitializeClient();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DABForgeConfig.SPEC);
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((mc, screen) -> new OptionsScreen((Screen)screen)));
        }
    }

    public static DetailArmorBarConfig getConfig() {
        if (config == null) {
            DetailArmorBar.loadConfig();
        }
        return config;
    }

    public static long getTicks() {
        return System.currentTimeMillis() / 50L;
    }

    private static void loadConfig() {
        File configFile = new File("config/", "detailarmorbar.json");
        config = new DetailArmorBarConfig(configFile);
        config.load();
    }

    public void onInitializeClient() {
        TextureOffset outline = new TextureOffset(9, 0);
        TextureOffset outlineHalf = new TextureOffset(27, 0);
        DetailArmorBarAPI.customArmorBarBuilder().armor((ArmorItem)Items.f_42481_, (ArmorItem)Items.f_42480_, (ArmorItem)Items.f_42482_, (ArmorItem)Items.f_42483_).render(itemStack -> new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(9, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(0, 9 + DetailArmorBar.isVanillaTexture()), outline, outlineHalf)).register();
        DetailArmorBarAPI.customArmorBarBuilder().armor((ArmorItem)Items.f_42472_, (ArmorItem)Items.f_42474_, (ArmorItem)Items.f_42473_, (ArmorItem)Items.f_42475_).render(itemStack -> new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(27, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(18, 9 + DetailArmorBar.isVanillaTexture()), outline, outlineHalf)).register();
        DetailArmorBarAPI.customArmorBarBuilder().armor((ArmorItem)Items.f_42354_).render(itemStack -> new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(45, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(36, 9 + DetailArmorBar.isVanillaTexture()), outline, outlineHalf)).register();
        DetailArmorBarAPI.customArmorBarBuilder().armor((ArmorItem)Items.f_42468_, (ArmorItem)Items.f_42470_, (ArmorItem)Items.f_42469_, (ArmorItem)Items.f_42471_).render(itemStack -> new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(63, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(54, 9 + DetailArmorBar.isVanillaTexture()), outline, outlineHalf)).register();
        DetailArmorBarAPI.customArmorBarBuilder().armor((ArmorItem)Items.f_42464_, (ArmorItem)Items.f_42466_, (ArmorItem)Items.f_42465_, (ArmorItem)Items.f_42467_).render(itemStack -> new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(81, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(72, 9 + DetailArmorBar.isVanillaTexture()), outline, outlineHalf)).register();
        DetailArmorBarAPI.customArmorBarBuilder().armor((ArmorItem)Items.f_42476_, (ArmorItem)Items.f_42478_, (ArmorItem)Items.f_42477_, (ArmorItem)Items.f_42479_).render(itemStack -> new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(99, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(90, 9 + DetailArmorBar.isVanillaTexture()), outline, outlineHalf)).register();
        DetailArmorBarAPI.customArmorBarBuilder().armor((ArmorItem)Items.f_42407_, (ArmorItem)Items.f_42462_, (ArmorItem)Items.f_42408_, (ArmorItem)Items.f_42463_).render(itemStack -> {
            int leatherArmor = ((DyeableLeatherItem)itemStack.m_41720_()).m_41121_(itemStack);
            Color color = new Color(leatherArmor);
            return new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(117, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(108, 9 + DetailArmorBar.isVanillaTexture()), outline, outlineHalf, color);
        }).register();
        DetailArmorBarAPI.customItemBarBuilder().item(Items.f_42741_).render(itemStack -> new ItemBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(36, 0), new TextureOffset(54, 0), true)).register();
        for (String compatibilityMod : compatibilityMods) {
            if (!ModList.get().getModObjectById(compatibilityMod).isPresent()) continue;
            DetailArmorBar.getConfig().getOptions().toggleCompatibleHeartMod = true;
        }
    }

    public static int isVanillaTexture() {
        return DetailArmorBar.getConfig().getOptions().toggleVanillaTexture ? 45 : 0;
    }
}

