/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.Nullable;

public class ClientTeamManager {
    public static ClientTeamManager INSTANCE;
    private final UUID managerId;
    private boolean invalid;
    public final Map<UUID, ClientTeam> teamMap;
    public final Map<UUID, KnownClientPlayer> knownPlayers;
    public ClientTeam selfTeam;
    public KnownClientPlayer selfKnownPlayer;

    public ClientTeamManager(UUID managerId) {
        this.managerId = managerId;
        this.invalid = false;
        this.teamMap = new HashMap<UUID, ClientTeam>();
        this.knownPlayers = new HashMap<UUID, KnownClientPlayer>();
    }

    public ClientTeamManager(FriendlyByteBuf buffer) {
        this(buffer.m_130259_());
        int nTeams = buffer.m_130242_();
        for (int i = 0; i < nTeams; ++i) {
            ClientTeam t = new ClientTeam(this, buffer);
            this.teamMap.put(t.getId(), t);
        }
        int nPlayers = buffer.m_130242_();
        for (int i = 0; i < nPlayers; ++i) {
            KnownClientPlayer knownClientPlayer = new KnownClientPlayer(buffer);
            this.knownPlayers.put(knownClientPlayer.uuid, knownClientPlayer);
        }
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void write(FriendlyByteBuf buffer, UUID selfTeamID) {
        buffer.m_130077_(this.getManagerId());
        buffer.m_130130_(this.teamMap.size());
        this.teamMap.values().forEach(clientTeam -> clientTeam.write(buffer, selfTeamID.equals(clientTeam.getId())));
        buffer.m_130130_(this.knownPlayers.size());
        for (KnownClientPlayer knownClientPlayer : this.knownPlayers.values()) {
            knownClientPlayer.write(buffer);
        }
    }

    public void initSelfDetails(UUID selfTeamID) {
        this.selfTeam = this.teamMap.get(selfTeamID);
        String username = Minecraft.m_91087_().m_91094_().m_92546_();
        UUID userId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
        this.selfKnownPlayer = this.knownPlayers.get(userId);
        if (this.selfKnownPlayer == null) {
            FTBTeams.LOGGER.warn("Local player id {} was not found in the known players list [{}]! FTB Teams will not be able to function correctly!", (Object)userId, (Object)String.join((CharSequence)",", this.knownPlayers.keySet().stream().map(UUID::toString).toList()));
        }
    }

    @Nullable
    public KnownClientPlayer getKnownPlayer(UUID id) {
        return this.knownPlayers.get(id);
    }

    @Nullable
    public ClientTeam getTeam(UUID id) {
        return this.teamMap.get(id);
    }

    public Component getName(@Nullable UUID id) {
        if (id == null || id.equals(Util.f_137441_)) {
            return new TextComponent("System").m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
        KnownClientPlayer p = this.knownPlayers.get(id);
        return new TextComponent(p == null ? "Unknown" : p.name).m_130940_(ChatFormatting.YELLOW);
    }

    public void invalidate() {
        this.teamMap.values().forEach(team -> {
            team.invalid = true;
        });
        this.invalid = true;
    }

    public static void syncFromServer(ClientTeamManager syncedData, UUID selfTeamID, boolean fullSync) {
        if (fullSync) {
            syncedData.initSelfDetails(selfTeamID);
            if (INSTANCE != null) {
                INSTANCE.invalidate();
            }
            INSTANCE = syncedData;
        } else if (INSTANCE != null) {
            syncedData.teamMap.forEach((teamID, clientTeam) -> {
                if (clientTeam.invalid) {
                    FTBTeams.LOGGER.debug("remove {} from client team map", teamID);
                    ClientTeamManager.INSTANCE.teamMap.remove(teamID);
                } else {
                    ClientTeam existing = ClientTeamManager.INSTANCE.teamMap.get(teamID);
                    if (existing != null) {
                        FTBTeams.LOGGER.debug("update {} in client team map", teamID);
                    } else {
                        FTBTeams.LOGGER.debug("insert {} into client team map", teamID);
                    }
                    ClientTeamManager.INSTANCE.teamMap.put((UUID)teamID, (ClientTeam)clientTeam);
                }
            });
            ClientTeamManager.INSTANCE.knownPlayers.putAll(syncedData.knownPlayers);
            INSTANCE.initSelfDetails(selfTeamID);
        }
    }
}

