/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.fluid;

import com.hrznstudio.titanium.fluid.TitaniumFluid;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class TitaniumFluidInstance
extends ForgeRegistryEntry<TitaniumFluidInstance> {
    private RegistryObject<Fluid> flowingFluid;
    private RegistryObject<Fluid> sourceFluid;
    private RegistryObject<Item> bucketFluid;
    private RegistryObject<Block> blockFluid;
    private final String fluid;

    public TitaniumFluidInstance(DeferredRegistryHelper helper, String fluid, FluidAttributes.Builder attributes, CreativeModeTab group) {
        this.fluid = fluid;
        this.sourceFluid = helper.registerGeneric(Fluid.class, fluid, () -> new TitaniumFluid.Source(attributes, this));
        this.flowingFluid = helper.registerGeneric(Fluid.class, fluid + "_flowing", () -> new TitaniumFluid.Flowing(attributes, this));
        this.bucketFluid = helper.registerGeneric(Item.class, fluid + "_bucket", () -> new BucketItem(this.sourceFluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(group)));
        this.blockFluid = helper.registerGeneric(Block.class, fluid, () -> new LiquidBlock(() -> (FlowingFluid)this.sourceFluid.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_()));
    }

    public RegistryObject<Fluid> getFlowingFluid() {
        return this.flowingFluid;
    }

    public RegistryObject<Fluid> getSourceFluid() {
        return this.sourceFluid;
    }

    public RegistryObject<Item> getBucketFluid() {
        return this.bucketFluid;
    }

    public RegistryObject<Block> getBlockFluid() {
        return this.blockFluid;
    }

    public String getFluid() {
        return this.fluid;
    }
}

