/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.button.MultiButtonComponent;
import com.hrznstudio.titanium.component.filter.MultiFilterComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.MultiTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.MultiInventoryComponent;
import com.hrznstudio.titanium.component.progress.MultiProgressBarHandler;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponentHarness;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;

public abstract class ActiveTile<T extends ActiveTile<T>>
extends BasicTile<T>
implements IScreenAddonProvider,
ITickableBlockEntity<T>,
MenuProvider,
IButtonHandler,
IFacingComponentHarness,
IContainerAddonProvider,
IHasAssetProvider {
    private MultiInventoryComponent<T> multiInventoryComponent;
    private MultiProgressBarHandler<T> multiProgressBarHandler;
    private MultiTankComponent<T> multiTankComponent;
    private MultiButtonComponent multiButtonComponent;
    private MultiFilterComponent multiFilterComponent;
    private List<IFactory<? extends IScreenAddon>> guiAddons = new ArrayList<IFactory<? extends IScreenAddon>>();
    private List<IFactory<? extends IContainerAddon>> containerAddons = new ArrayList<IFactory<? extends IContainerAddon>>();
    private List<IComponentBundle> bundles = new ArrayList<IComponentBundle>();

    public ActiveTile(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    @Override
    @ParametersAreNonnullByDefault
    public InteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (this.multiTankComponent != null && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)((IFluidHandler)this.multiTankComponent.getCapabilityForSide(null).orElse(new MultiTankComponent.MultiTankCapabilityHandler(new ArrayList()))))) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
    }

    public void openGui(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer(buffer, new TileEntityLocatorInstance(this.f_58858_)));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new BasicAddonContainer(this, new TileEntityLocatorInstance(this.f_58858_), this.getWorldPosCallable(), inventoryPlayer, menu);
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent(this.getBasicTileBlock().m_7705_()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY));
    }

    public void addInventory(InventoryComponent<T> handler) {
        if (this.multiInventoryComponent == null) {
            this.multiInventoryComponent = new MultiInventoryComponent();
        }
        this.multiInventoryComponent.add(handler.setComponentHarness(this.getSelf()));
    }

    public void addProgressBar(ProgressBarComponent<T> progressBarComponent) {
        if (this.multiProgressBarHandler == null) {
            this.multiProgressBarHandler = new MultiProgressBarHandler();
        }
        this.multiProgressBarHandler.add(progressBarComponent.setComponentHarness(this.getSelf()));
    }

    public void addTank(FluidTankComponent<T> tank) {
        if (this.multiTankComponent == null) {
            this.multiTankComponent = new MultiTankComponent();
        }
        this.multiTankComponent.add(tank.setComponentHarness(this.getSelf()));
    }

    public void addButton(ButtonComponent button) {
        if (this.multiButtonComponent == null) {
            this.multiButtonComponent = new MultiButtonComponent();
        }
        this.multiButtonComponent.add(button);
    }

    public void addFilter(IFilter<?> filter) {
        if (this.multiFilterComponent == null) {
            this.multiFilterComponent = new MultiFilterComponent();
        }
        this.multiFilterComponent.add(filter);
    }

    public void addBundle(IComponentBundle bundle) {
        if (this.multiInventoryComponent == null) {
            this.multiInventoryComponent = new MultiInventoryComponent();
        }
        if (this.multiProgressBarHandler == null) {
            this.multiProgressBarHandler = new MultiProgressBarHandler();
        }
        if (this.multiTankComponent == null) {
            this.multiTankComponent = new MultiTankComponent();
        }
        if (this.multiButtonComponent == null) {
            this.multiButtonComponent = new MultiButtonComponent();
        }
        if (this.multiFilterComponent == null) {
            this.multiFilterComponent = new MultiFilterComponent();
        }
        bundle.accept(this.multiInventoryComponent, this.multiProgressBarHandler, this.multiTankComponent, this.multiButtonComponent, this.multiFilterComponent);
        bundle.getContainerAddons().forEach(this::addContainerAddonFactory);
        this.bundles.add(bundle);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.bundles.stream().forEach(iComponentBundle -> iComponentBundle.getScreenAddons().forEach(this::addGuiAddonFactory));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.multiInventoryComponent != null) {
            return this.multiInventoryComponent.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), side)).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.multiTankComponent != null) {
            return this.multiTankComponent.getCapabilityForSide(FacingUtil.getFacingRelative(this.getFacingDirection(), side)).cast();
        }
        return LazyOptional.empty();
    }

    public MultiInventoryComponent<T> getMultiInventoryComponent() {
        return this.multiInventoryComponent;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addGuiAddonFactory(IFactory<? extends IScreenAddon> factory) {
        this.guiAddons.add(factory);
    }

    public void addContainerAddonFactory(IFactory<? extends IContainerAddon> factory) {
        this.containerAddons.add(factory);
    }

    @Override
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>(this.guiAddons);
        if (this.multiInventoryComponent != null) {
            addons.addAll(this.multiInventoryComponent.getScreenAddons());
        }
        if (this.multiProgressBarHandler != null) {
            addons.addAll(this.multiProgressBarHandler.getScreenAddons());
        }
        if (this.multiTankComponent != null) {
            addons.addAll(this.multiTankComponent.getScreenAddons());
        }
        if (this.multiButtonComponent != null) {
            addons.addAll(this.multiButtonComponent.getScreenAddons());
        }
        if (this.multiFilterComponent != null) {
            addons.addAll(this.multiFilterComponent.getScreenAddons());
        }
        return addons;
    }

    @Override
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> addons = new ArrayList<IFactory<? extends IContainerAddon>>(this.containerAddons);
        if (this.multiInventoryComponent != null) {
            addons.addAll(this.multiInventoryComponent.getContainerAddons());
        }
        if (this.multiProgressBarHandler != null) {
            addons.addAll(this.multiProgressBarHandler.getContainerAddons());
        }
        if (this.multiTankComponent != null) {
            addons.addAll(this.multiTankComponent.getContainerAddons());
        }
        return addons;
    }

    @Override
    public IAssetProvider getAssetProvider() {
        return IAssetProvider.DEFAULT_PROVIDER;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        block5: {
            Iterator<IScreenAddonProvider> iterator;
            if (this.multiProgressBarHandler != null) {
                this.multiProgressBarHandler.update();
            }
            if (level.m_46467_() % (long)this.getFacingHandlerWorkTime() != 0L) break block5;
            if (this.multiInventoryComponent != null) {
                InventoryComponent inventoryHandler;
                iterator = this.multiInventoryComponent.getInventoryHandlers().iterator();
                while (!(!iterator.hasNext() || (inventoryHandler = (InventoryComponent)iterator.next()) instanceof IFacingComponent && ((IFacingComponent)((Object)inventoryHandler)).work(this.f_58857_, this.f_58858_, this.getFacingDirection(), this.getFacingHandlerWorkAmount()))) {
                }
            }
            if (this.multiTankComponent != null) {
                FluidTankComponent tank;
                iterator = this.multiTankComponent.getTanks().iterator();
                while (!(!iterator.hasNext() || (tank = (FluidTankComponent)iterator.next()) instanceof IFacingComponent && ((IFacingComponent)((Object)tank)).work(this.f_58857_, this.f_58858_, this.getFacingDirection(), this.getFacingHandlerWorkAmount()))) {
                }
            }
        }
    }

    public int getFacingHandlerWorkTime() {
        return 10;
    }

    public int getFacingHandlerWorkAmount() {
        return 4;
    }

    public MultiButtonComponent getMultiButtonComponent() {
        return this.multiButtonComponent;
    }

    public Direction getFacingDirection() {
        return this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)RotatableBlock.FACING_ALL) ? (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)RotatableBlock.FACING_ALL) : (this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)RotatableBlock.FACING_HORIZONTAL) ? (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)RotatableBlock.FACING_HORIZONTAL) : Direction.NORTH);
    }

    @Override
    public IFacingComponent getHandlerFromName(String string) {
        if (this.multiInventoryComponent != null) {
            for (InventoryComponent inventoryComponent : this.multiInventoryComponent.getInventoryHandlers()) {
                if (!(inventoryComponent instanceof IFacingComponent) || !inventoryComponent.getName().equalsIgnoreCase(string)) continue;
                return (IFacingComponent)((Object)inventoryComponent);
            }
        }
        if (this.multiTankComponent != null) {
            for (FluidTankComponent fluidTankComponent : this.multiTankComponent.getTanks()) {
                if (!(fluidTankComponent instanceof IFacingComponent) || !fluidTankComponent.getName().equalsIgnoreCase(string)) continue;
                return (IFacingComponent)((Object)fluidTankComponent);
            }
        }
        return null;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        if (id == -3 && !compound.m_128441_("Invalid") && compound.m_128441_("Fill") && !playerEntity.f_36096_.m_142621_().m_41619_()) {
            boolean fill = compound.m_128471_("Fill");
            String name = compound.m_128461_("Name");
            if (this.multiTankComponent != null) {
                for (FluidTankComponent fluidTankComponent : this.multiTankComponent.getTanks()) {
                    if (!fluidTankComponent.getName().equalsIgnoreCase(name)) continue;
                    playerEntity.f_36096_.m_142621_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
                        if (fill) {
                            int amount = playerEntity.f_36096_.m_142621_().m_41720_() instanceof BucketItem ? 1000 : Integer.MAX_VALUE;
                            amount = fluidTankComponent.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
                            iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        } else {
                            int amount = playerEntity.f_36096_.m_142621_().m_41720_() instanceof BucketItem ? 1000 : Integer.MAX_VALUE;
                            amount = iFluidHandlerItem.fill(fluidTankComponent.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE);
                            fluidTankComponent.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        }
                        playerEntity.f_36096_.m_142503_(iFluidHandlerItem.getContainer().m_41777_());
                        if (playerEntity instanceof ServerPlayer) {
                            playerEntity.f_36096_.m_38946_();
                        }
                    });
                }
            }
        }
        if (id == -2) {
            String name = compound.m_128461_("Name");
            if (this.multiFilterComponent != null) {
                for (IFilter filter : this.multiFilterComponent.getFilters()) {
                    if (!filter.getName().equals(name)) continue;
                    int slot = compound.m_128451_("Slot");
                    filter.setFilter(slot, ItemStack.m_41712_((CompoundTag)compound.m_128469_("Filter")));
                    this.markForUpdate();
                    break;
                }
            }
        }
        if (id == -1) {
            String name = compound.m_128461_("Name");
            FacingUtil.Sideness facing = FacingUtil.Sideness.valueOf(compound.m_128461_("Facing"));
            int faceMode = compound.m_128451_("Next");
            if (this.multiInventoryComponent != null && this.multiInventoryComponent.handleFacingChange(name, facing, faceMode)) {
                this.markForUpdate();
            } else if (this.multiTankComponent != null && this.multiTankComponent.handleFacingChange(name, facing, faceMode)) {
                this.markForUpdate();
            }
        } else if (this.multiButtonComponent != null) {
            this.multiButtonComponent.clickButton(id, playerEntity, compound);
        }
    }

    @Nonnull
    public abstract T getSelf();

    @Override
    public Level getComponentWorld() {
        return this.getSelf().m_58904_();
    }

    @Override
    public void markComponentDirty() {
        super.m_6596_();
    }

    @Override
    public void markComponentForUpdate(boolean referenced) {
        if (!referenced) {
            super.markForUpdate();
        } else {
            this.markComponentDirty();
        }
    }

    public ContainerLevelAccess getWorldPosCallable() {
        return this.m_58904_() != null ? ContainerLevelAccess.m_39289_((Level)this.m_58904_(), (BlockPos)this.m_58899_()) : ContainerLevelAccess.f_39287_;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.multiInventoryComponent != null) {
            this.multiInventoryComponent.getLazyOptionals().forEach(LazyOptional::invalidate);
        }
        if (this.multiTankComponent != null) {
            this.multiTankComponent.getLazyOptionals().forEach(LazyOptional::invalidate);
        }
    }

    @Override
    public boolean canInteract() {
        return this.f_58857_.m_7702_(this.f_58858_) == this;
    }
}

