/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.computer.core.ResourceMount;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.metrics.ComputerMBean;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.UpgradesLoadedMessage;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="computercraft")
public final class CommonHooks {
    public static final ResourceLocation LOOT_TREASURE_DISK = new ResourceLocation("computercraft", "treasure_disk");
    private static final Set<ResourceLocation> TABLES = new HashSet<ResourceLocation>(Arrays.asList(BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78763_, BuiltInLootTables.f_78762_, BuiltInLootTables.f_78761_, BuiltInLootTables.f_78764_, BuiltInLootTables.f_78686_, BuiltInLootTables.f_78688_, BuiltInLootTables.f_78689_, BuiltInLootTables.f_78746_));

    private CommonHooks() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerContext.get(ServerLifecycleHooks.getCurrentServer()).tick();
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent event) {
        CommandComputerCraft.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        if (server instanceof DedicatedServer) {
            DedicatedServer dediServer = (DedicatedServer)server;
            if (dediServer.m_7913_().f_139721_) {
                ComputerMBean.register();
            }
        }
        CommonHooks.resetState();
        ServerContext.create(server);
        ComputerMBean.start(server);
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        CommonHooks.resetState();
    }

    private static void resetState() {
        ServerContext.close();
        WirelessNetwork.resetNetworks();
        NetworkUtils.reset();
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if (!name.m_135827_().equals("minecraft") || !TABLES.contains(name)) {
            return;
        }
        event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)LOOT_TREASURE_DISK)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).name("computercraft_treasure").m_79082_());
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ResourceMount.RELOAD_LISTENER);
        event.addListener(TurtleUpgrades.instance());
        event.addListener(PocketUpgrades.instance());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        UpgradesLoadedMessage packet = new UpgradesLoadedMessage();
        if (event.getPlayer() == null) {
            NetworkHandler.sendToAllPlayers(packet);
        } else {
            NetworkHandler.sendToPlayer(event.getPlayer(), packet);
        }
    }

    @SubscribeEvent
    public static void onMissingEntityMappingsEvent(RegistryEvent.MissingMappings<EntityType<?>> event) {
        ResourceLocation id = new ResourceLocation("computercraft", "turtle_player");
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("computercraft")) {
            if (!mapping.key.equals((Object)id)) continue;
            mapping.ignore();
        }
    }
}

