/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.data.PrettyJsonWriter;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModelProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;
    private final Consumer<BlockModelGenerators> blocks;
    private final Consumer<ItemModelGenerators> items;

    public ModelProvider(DataGenerator generator, Consumer<BlockModelGenerators> blocks, Consumer<ItemModelGenerators> items) {
        this.generator = generator;
        this.blocks = blocks;
        this.items = items;
    }

    public void m_6865_(@Nonnull HashCache output) {
        HashMap blockStates = new HashMap();
        Consumer<BlockStateGenerator> addBlockState = generator -> {
            Block block = generator.m_6968_();
            if (blockStates.containsKey(block)) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
            blockStates.put(block, generator);
        };
        HashMap<ResourceLocation, DelegatedModel> models = new HashMap<ResourceLocation, DelegatedModel>();
        BiConsumer<ResourceLocation, Supplier> addModel = (id, contents) -> {
            if (models.containsKey(id)) {
                throw new IllegalStateException("Duplicate model definition for " + id);
            }
            models.put((ResourceLocation)id, (DelegatedModel)contents);
        };
        HashSet explicitItems = new HashSet();
        this.blocks.accept(new BlockModelGenerators(addBlockState, addModel, explicitItems::add));
        this.items.accept(new ItemModelGenerators(addModel));
        for (Block block : ForgeRegistries.BLOCKS) {
            ResourceLocation model;
            Item item;
            if (!blockStates.containsKey(block) || (item = (Item)Item.f_41373_.get(block)) == null || explicitItems.contains(item) || models.containsKey(model = ModelLocationUtils.m_125571_((Item)item))) continue;
            models.put(model, new DelegatedModel(ModelLocationUtils.m_125576_((Block)block)));
        }
        this.saveCollection(output, this.generator.m_123916_(), blockStates, ModelProvider::createBlockStatePath);
        this.saveCollection(output, this.generator.m_123916_(), models, ModelProvider::createModelPath);
    }

    private <T> void saveCollection(HashCache output, Path root, Map<T, ? extends Supplier<JsonElement>> items, BiFunction<Path, T, Path> getLocation) {
        for (Map.Entry<T, Supplier<JsonElement>> entry : items.entrySet()) {
            Path path = getLocation.apply(root, (Path)entry.getKey());
            try {
                String contents;
                try (StringWriter writer = new StringWriter();
                     JsonWriter jsonWriter = PrettyJsonWriter.createWriter(writer);){
                    GSON.toJson(entry.getValue().get(), jsonWriter);
                    contents = writer.toString();
                }
                String hash = f_123918_.hashUnencodedChars((CharSequence)contents).toString();
                if (!Objects.equals(output.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(contents);
                    }
                }
                output.m_123940_(path, hash);
            }
            catch (Exception exception) {
                ComputerCraft.log.error("Couldn't save {}", (Object)path, (Object)exception);
            }
        }
    }

    private static Path createBlockStatePath(Path path, Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
        return path.resolve("assets/" + id.m_135827_() + "/blockstates/" + id.m_135815_() + ".json");
    }

    private static Path createModelPath(Path path, ResourceLocation id) {
        return path.resolve("assets/" + id.m_135827_() + "/models/" + id.m_135815_() + ".json");
    }

    @Nonnull
    public String m_6055_() {
        return "Block State Definitions";
    }
}

