/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.render.MonitorTextureBufferShader;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.client.util.DirectBuffers;
import dan200.computercraft.client.util.DirectVertexBuffer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.integration.ShaderMod;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.lwjgl.opengl.GL11;

public class TileEntityMonitorRenderer
implements BlockEntityRenderer<TileMonitor> {
    private static final float MARGIN = 0.034375f;
    private static final Matrix3f IDENTITY_NORMAL = (Matrix3f)Util.m_137469_((Object)new Matrix3f(), Matrix3f::m_8180_);
    private static ByteBuffer backingBuffer;

    public TileEntityMonitorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull TileMonitor monitor, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource bufferSource, int lightmapCoord, int overlayLight) {
        ClientMonitor originTerminal = monitor.getClientMonitor();
        if (originTerminal == null) {
            return;
        }
        TileMonitor origin = originTerminal.getOrigin();
        BlockPos monitorPos = monitor.m_58899_();
        long renderFrame = FrameInfo.getRenderFrame();
        if (originTerminal.lastRenderFrame == renderFrame && !monitorPos.equals((Object)originTerminal.lastRenderPos)) {
            return;
        }
        originTerminal.lastRenderFrame = renderFrame;
        originTerminal.lastRenderPos = monitorPos;
        BlockPos originPos = origin.m_58899_();
        Direction dir = origin.getDirection();
        Direction front = origin.getFront();
        float yaw = dir.m_122435_();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.m_85836_();
        transform.m_85837_((double)(originPos.m_123341_() - monitorPos.m_123341_()) + 0.5, (double)(originPos.m_123342_() - monitorPos.m_123342_()) + 0.5, (double)(originPos.m_123343_() - monitorPos.m_123343_()) + 0.5);
        transform.m_85845_(Vector3f.f_122224_.m_122240_(yaw));
        transform.m_85845_(Vector3f.f_122223_.m_122240_(pitch));
        transform.m_85837_(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null && !ShaderMod.INSTANCE.isRenderingShadowPass()) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.m_85836_();
            transform.m_85841_((float)xScale, (float)(-yScale), 1.0f);
            Matrix4f matrix = transform.m_85850_().m_85861_();
            TileEntityMonitorRenderer.renderTerminal(matrix, originTerminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            transform.m_85849_();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.m_6299_(RenderTypes.TERMINAL)), -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        transform.m_85849_();
    }

    private static void renderTerminal(Matrix4f matrix, ClientMonitor monitor, float xMargin, float yMargin) {
        Terminal terminal = monitor.getTerminal();
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int pixelWidth = width * 6;
        int pixelHeight = height * 9;
        MonitorRenderer renderType = MonitorRenderer.current();
        boolean redraw = monitor.pollTerminalChanged();
        if (monitor.createBuffer(renderType)) {
            redraw = true;
        }
        switch (renderType) {
            case TBO: {
                if (redraw) {
                    ByteBuffer terminalBuffer = TileEntityMonitorRenderer.getBuffer(width * height * 3);
                    MonitorTextureBufferShader.setTerminalData(terminalBuffer, terminal);
                    DirectBuffers.setBufferData(35882, monitor.tboBuffer, terminalBuffer, 35044);
                    ByteBuffer uniformBuffer = TileEntityMonitorRenderer.getBuffer(276);
                    MonitorTextureBufferShader.setUniformData(uniformBuffer, terminal);
                    DirectBuffers.setBufferData(35345, monitor.tboUniform, uniformBuffer, 35044);
                }
                int active = GlStateManager.m_157058_();
                RenderSystem.m_69388_((int)33987);
                GL11.glBindTexture((int)35882, (int)monitor.tboTexture);
                RenderSystem.m_69388_((int)active);
                MonitorTextureBufferShader shader = RenderTypes.getMonitorTextureBufferShader();
                shader.setupUniform(monitor.tboUniform);
                BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                buffer.m_166779_(RenderTypes.MONITOR_TBO.m_173186_(), RenderTypes.MONITOR_TBO.m_110508_());
                TileEntityMonitorRenderer.tboVertex((VertexConsumer)buffer, matrix, -xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex((VertexConsumer)buffer, matrix, -xMargin, (float)pixelHeight + yMargin);
                TileEntityMonitorRenderer.tboVertex((VertexConsumer)buffer, matrix, (float)pixelWidth + xMargin, -yMargin);
                TileEntityMonitorRenderer.tboVertex((VertexConsumer)buffer, matrix, (float)pixelWidth + xMargin, (float)pixelHeight + yMargin);
                RenderTypes.MONITOR_TBO.m_110412_(buffer, 0, 0, 0);
                break;
            }
            case VBO: {
                DirectVertexBuffer backgroundBuffer = monitor.backgroundBuffer;
                DirectVertexBuffer foregroundBuffer = monitor.foregroundBuffer;
                if (redraw) {
                    int size = DirectFixedWidthFontRenderer.getVertexCount(terminal);
                    TileEntityMonitorRenderer.renderToBuffer(backgroundBuffer, size, sink -> DirectFixedWidthFontRenderer.drawTerminalBackground(sink, 0.0f, 0.0f, terminal, yMargin, yMargin, xMargin, xMargin));
                    TileEntityMonitorRenderer.renderToBuffer(foregroundBuffer, size, sink -> {
                        DirectFixedWidthFontRenderer.drawTerminalForeground(sink, 0.0f, 0.0f, terminal);
                        DirectFixedWidthFontRenderer.drawCursor(sink, 0.0f, 0.0f, terminal);
                    });
                }
                Matrix3f oldInverseRotation = RenderSystem.m_200906_();
                RenderSystem.m_200918_((Matrix3f)IDENTITY_NORMAL);
                RenderTypes.TERMINAL.m_110185_();
                backgroundBuffer.m_166867_(matrix, RenderSystem.m_157192_(), RenderTypes.getTerminalShader());
                GL11.glPolygonOffset((float)-1.0f, (float)-10.0f);
                GL11.glEnable((int)32823);
                foregroundBuffer.drawWithShader(matrix, RenderSystem.m_157192_(), RenderTypes.getTerminalShader(), FixedWidthFontRenderer.isCursorVisible(terminal) && FrameInfo.getGlobalCursorBlink() ? foregroundBuffer.getIndexCount() + 6 : foregroundBuffer.getIndexCount());
                GL11.glPolygonOffset((float)0.0f, (float)-0.0f);
                GL11.glDisable((int)32823);
                RenderTypes.TERMINAL.m_110188_();
                RenderSystem.m_200918_((Matrix3f)oldInverseRotation);
                break;
            }
        }
    }

    private static void renderToBuffer(DirectVertexBuffer vbo, int size, Consumer<DirectFixedWidthFontRenderer.QuadEmitter> draw) {
        DirectFixedWidthFontRenderer.QuadEmitter sink = ShaderMod.INSTANCE.getQuadEmitter(size, TileEntityMonitorRenderer::getBuffer);
        ByteBuffer buffer = sink.buffer();
        draw.accept(sink);
        buffer.flip();
        vbo.upload(buffer.limit() / sink.format().m_86020_(), RenderTypes.TERMINAL.m_173186_(), sink.format(), buffer);
    }

    private static void tboVertex(VertexConsumer builder, Matrix4f matrix, float x, float y) {
        builder.m_85982_(matrix, x, y, 0.0f).m_7421_(x, y).m_5752_();
    }

    @Nonnull
    private static ByteBuffer getBuffer(int capacity) {
        ByteBuffer buffer = backingBuffer;
        if (buffer == null || buffer.capacity() < capacity) {
            backingBuffer = buffer == null ? MemoryTracker.m_182527_((int)capacity) : MemoryTracker.m_182529_((ByteBuffer)buffer, (int)capacity);
            buffer = backingBuffer;
        }
        buffer.clear();
        return buffer;
    }

    public int m_142163_() {
        return ComputerCraft.monitorDistance;
    }
}

