/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.common.Backpack;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.ProgressFormatters;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.tracker.CountProgressTracker;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EndCrystalBackpack
extends Backpack {
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "end_crystal");

    public EndCrystalBackpack() {
        super(ID);
    }

    @Override
    public Supplier<Object> getModelSupplier() {
        return ClientHandler.getModelInstances()::getEndCrystal;
    }

    @Override
    @Nullable
    protected IProgressTracker createProgressTracker() {
        return new CountProgressTracker(1, ProgressFormatters.INCOMPLETE_COMPLETE);
    }

    @SubscribeEvent
    public void onKillLivingEntity(LivingDeathEvent event) {
        Entity sourceEntity = event.getSource().m_7639_();
        if (event.getEntityLiving() instanceof EnderDragon && sourceEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceEntity;
            UnlockTracker.get((Player)player).ifPresent(unlockTracker -> unlockTracker.getProgressTracker(ID).ifPresent(progressTracker -> ((CountProgressTracker)progressTracker).increment(player)));
        }
    }
}

