/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.BackpackedButtonBindings;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientEvents;
import com.mrcrayfish.backpacked.client.ControllerHandler;
import com.mrcrayfish.backpacked.client.ModelInstances;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.ShelfRenderer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.VillagerBackpackLayer;
import com.mrcrayfish.backpacked.common.BackpackManager;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientHandler {
    public static final KeyMapping KEY_BACKPACK = new KeyMapping("key.backpack", 66, "key.categories.inventory");
    public static final ModelInstances MODELS = new ModelInstances();

    public static void setup() {
        ClientRegistry.registerKeyBinding((KeyMapping)KEY_BACKPACK);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.BACKPACK.get()), BackpackScreen::new);
        if (Backpacked.isControllableLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
            BackpackedButtonBindings.register();
        }
        BackpackManager.instance().getRegisteredBackpacks().forEach(backpack -> BackpackLayer.registerModel(backpack.getId(), () -> (BackpackModel)((Object)((Object)((Object)backpack.getModelSupplier().get())))));
    }

    public static ModelInstances getModelInstances() {
        return MODELS;
    }

    public static void onRegisterLayers(EntityRenderersEvent.AddLayers event) {
        ClientHandler.addBackpackLayer(event.getSkin("default"));
        ClientHandler.addBackpackLayer(event.getSkin("slim"));
        LivingEntityRenderer renderer = event.getRenderer(EntityType.f_20494_);
        if (renderer instanceof WanderingTraderRenderer) {
            WanderingTraderRenderer traderRenderer = (WanderingTraderRenderer)renderer;
            traderRenderer.m_115326_(new VillagerBackpackLayer(traderRenderer));
        }
    }

    private static void addBackpackLayer(LivingEntityRenderer<?, ?> renderer) {
        if (renderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.m_115326_(new BackpackLayer(playerRenderer));
        }
    }

    public static void createBackpackTooltip(ItemStack stack, List<Component> list) {
        CompoundTag tag;
        if (!((Boolean)Config.SERVER.lockBackpackIntoSlot.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && Backpacked.getBackpackStack((Player)mc.f_91074_).equals(stack) && (tag = stack.m_41783_()) != null && !tag.m_128437_("Items", 10).isEmpty()) {
            mc.f_91062_.m_92865_().m_92414_((FormattedText)BackpackItem.REMOVE_ITEMS_TOOLTIP, 150, Style.f_131099_).forEach(formattedText -> list.add((Component)new TextComponent(formattedText.getString()).m_130940_(ChatFormatting.RED)));
        }
    }

    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SHELF.get(), ShelfRenderer::new);
    }
}

