/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.command.argument.ScaleEasingArgumentType;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.server.command.ScaleCommand;
import virtuoel.pehkui.util.VersionUtils;

public class CommandUtils {
    public static void registerArgumentTypes() {
        if (VersionUtils.MINOR <= 18) {
            CommandUtils.registerArgumentTypes(CommandUtils::registerConstantArgumentType);
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        ScaleCommand.register(dispatcher);
        DebugCommand.register(dispatcher);
    }

    public static void registerArgumentTypes(ArgumentTypeConsumer consumer) {
        consumer.register(Pehkui.id("scale_type"), ScaleTypeArgumentType.class, ScaleTypeArgumentType::scaleType);
        consumer.register(Pehkui.id("scale_modifier"), ScaleModifierArgumentType.class, ScaleModifierArgumentType::scaleModifier);
        consumer.register(Pehkui.id("scale_operation"), ScaleOperationArgumentType.class, ScaleOperationArgumentType::operation);
        consumer.register(Pehkui.id("scale_easing"), ScaleEasingArgumentType.class, ScaleEasingArgumentType::scaleEasing);
    }

    public static void sendFeedback(CommandSourceStack source, Supplier<Component> text, boolean broadcastToOps) {
        source.m_81354_(text.get(), broadcastToOps);
    }

    public static boolean testFloatRange(MinMaxBounds.Doubles range, float value) {
        return range.m_154810_((double)value);
    }

    public static <T extends ArgumentType<?>> void registerConstantArgumentType(ResourceLocation id, Class<T> argClass, Supplier<T> supplier) {
        ArgumentTypes.m_121601_((String)id.toString(), argClass, (ArgumentSerializer)new EmptyArgumentSerializer(supplier));
    }

    public static CompletableFuture<Suggestions> suggestIdentifiersIgnoringNamespace(String namespace, Iterable<ResourceLocation> candidates, SuggestionsBuilder builder) {
        CommandUtils.forEachMatchingIgnoringNamespace(namespace, candidates, builder.getRemaining().toLowerCase(Locale.ROOT), Function.identity(), id -> builder.suggest(String.valueOf(id)));
        return builder.buildFuture();
    }

    public static <T> void forEachMatchingIgnoringNamespace(String namespace, Iterable<T> candidates, String string, Function<T, ResourceLocation> idFunc, Consumer<T> action) {
        boolean hasColon = string.indexOf(58) > -1;
        for (T object : candidates) {
            ResourceLocation id = idFunc.apply(object);
            if (hasColon) {
                if (!CommandUtils.wordStartsWith(string, id.toString(), '_')) continue;
                action.accept(object);
                continue;
            }
            if (!CommandUtils.wordStartsWith(string, id.m_135827_(), '_') && (!id.m_135827_().equals(namespace) || !CommandUtils.wordStartsWith(string, id.m_135815_(), '_'))) continue;
            action.accept(object);
        }
    }

    public static boolean wordStartsWith(String string, String substring, char wordSeparator) {
        int i = 0;
        while (!substring.startsWith(string, i)) {
            if ((i = substring.indexOf(wordSeparator, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @FunctionalInterface
    public static interface ArgumentTypeConsumer {
        public <T extends ArgumentType<?>> void register(ResourceLocation var1, Class<T> var2, Supplier<T> var3);
    }
}

