/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.util.MulticonnectCompatibility;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"tickMovement"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setVelocity(DDD)V", shift=At.Shift.AFTER)})
    private void pehkui$tickMovement$minVelocity(CallbackInfo info, @Local Vec3 velocity) {
        LivingEntity self = (LivingEntity)this;
        float scale = ScaleUtils.getMotionScale((Entity)self);
        if (scale < 1.0f) {
            double min = (double)scale * MulticonnectCompatibility.INSTANCE.getProtocolDependentValue(ver -> ver <= 47, 0.005, 0.003);
            double vX = velocity.f_82479_;
            double vY = velocity.f_82480_;
            double vZ = velocity.f_82481_;
            if (Math.abs(vX) < min) {
                vX = 0.0;
            }
            if (Math.abs(vY) < min) {
                vY = 0.0;
            }
            if (Math.abs(vZ) < min) {
                vZ = 0.0;
            }
            self.m_20334_(vX, vY, vZ);
        }
    }

    @ModifyVariable(method={"applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"}, at=@At(value="HEAD"), argsOnly=true)
    private float pehkui$applyArmorToDamage(float value, DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        float attackScale = attacker == null ? 1.0f : ScaleUtils.getAttackScale(attacker);
        float defenseScale = ScaleUtils.getDefenseScale((Entity)this);
        if (attackScale != 1.0f || defenseScale != 1.0f) {
            value = attackScale * value / defenseScale;
        }
        return value;
    }

    @ModifyReturnValue(method={"getMaxHealth"}, at={@At(value="RETURN")})
    private float pehkui$getMaxHealth(float original) {
        float scale = ScaleUtils.getHealthScale((Entity)this);
        return scale != 1.0f ? original * scale : original;
    }

    @ModifyReturnValue(method={"getAttackDistanceScalingFactor"}, at={@At(value="RETURN")})
    private double pehkui$getAttackDistanceScalingFactor(double original) {
        float scale = ScaleUtils.getVisibilityScale((Entity)this);
        return scale != 1.0f ? original * (double)scale : original;
    }

    @ModifyReturnValue(method={"applyClimbingSpeed(Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"}, at={@At(value="RETURN")})
    private Vec3 pehkui$applyClimbingSpeed(Vec3 original) {
        LivingEntity self = (LivingEntity)this;
        if (!self.m_6147_()) {
            return original;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AABB bounds = self.m_142469_();
            double halfUnscaledXLength = bounds.m_82362_() / (double)width / 2.0;
            int minX = Mth.m_14107_((double)(bounds.f_82288_ + halfUnscaledXLength));
            int maxX = Mth.m_14107_((double)(bounds.f_82291_ - halfUnscaledXLength));
            int minY = Mth.m_14107_((double)bounds.f_82289_);
            double halfUnscaledZLength = bounds.m_82385_() / (double)width / 2.0;
            int minZ = Mth.m_14107_((double)(bounds.f_82290_ + halfUnscaledZLength));
            int maxZ = Mth.m_14107_((double)(bounds.f_82293_ - halfUnscaledZLength));
            Level world = self.m_20193_();
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!world.m_8055_(pos).isScaffolding(self)) continue;
                return new Vec3(original.f_82479_, Math.max(self.m_20184_().f_82480_, -0.15), original.f_82481_);
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"isClimbing()Z"}, at={@At(value="RETURN")})
    private boolean pehkui$isClimbing(boolean original) {
        LivingEntity self = (LivingEntity)this;
        if (original || self.m_5833_()) {
            return original;
        }
        float width = ScaleUtils.getBoundingBoxWidthScale((Entity)self);
        if (width > 1.0f) {
            AABB bounds = self.m_142469_();
            double halfUnscaledXLength = bounds.m_82362_() / (double)width / 2.0;
            int minX = Mth.m_14107_((double)(bounds.f_82288_ + halfUnscaledXLength));
            int maxX = Mth.m_14107_((double)(bounds.f_82291_ - halfUnscaledXLength));
            int minY = Mth.m_14107_((double)bounds.f_82289_);
            double halfUnscaledZLength = bounds.m_82385_() / (double)width / 2.0;
            int minZ = Mth.m_14107_((double)(bounds.f_82290_ + halfUnscaledZLength));
            int maxZ = Mth.m_14107_((double)(bounds.f_82293_ - halfUnscaledZLength));
            Level world = self.m_20193_();
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)minY, (int)maxZ)) {
                if (!world.m_8055_(pos).isLadder((LevelReader)world, pos, self)) continue;
                return true;
            }
        }
        return original;
    }

    @WrapOperation(method={"tickCramming"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getBoundingBox()Lnet/minecraft/util/math/Box;")})
    private AABB pehkui$tickCramming$getBoundingBox(LivingEntity obj, Operation<AABB> original) {
        AABB bounds = (AABB)original.call(new Object[]{obj});
        float interactionWidth = ScaleUtils.getInteractionBoxWidthScale((Entity)obj);
        float interactionHeight = ScaleUtils.getInteractionBoxHeightScale((Entity)obj);
        if (interactionWidth != 1.0f || interactionHeight != 1.0f) {
            double scaledXLength = bounds.m_82362_() * 0.5 * (double)(interactionWidth - 1.0f);
            double scaledYLength = bounds.m_82376_() * 0.5 * (double)(interactionHeight - 1.0f);
            double scaledZLength = bounds.m_82385_() * 0.5 * (double)(interactionWidth - 1.0f);
            return bounds.m_82377_(scaledXLength, scaledYLength, scaledZLength);
        }
        return bounds;
    }
}

