/*
 * Decompiled with CFR 0.152.
 */
package com.morearrows.specialarrowentities.padded;

import com.morearrows.lists.ArrowEntities;
import com.morearrows.lists.ArrowItems;
import com.morearrows.lists.backend.ArrowsAPI;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class CupidsArrowEntity
extends AbstractArrow {
    public CupidsArrowEntity(EntityType<? extends CupidsArrowEntity> entType, Level level) {
        super(entType, level);
        this.m_36781_(0.0);
    }

    public CupidsArrowEntity(Level level, LivingEntity liveEntity) {
        super((EntityType)ArrowEntities.cupids_arrow.get(), liveEntity, level);
        this.m_36781_(0.0);
        if (liveEntity instanceof Player && ((Player)liveEntity).m_150110_().f_35937_) {
            this.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }

    public CupidsArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)ArrowEntities.cupids_arrow.get(), x, y, z, level);
        this.m_36781_(0.0);
    }

    public void m_36740_(@NotNull SoundEvent p_36741_) {
        this.f_36700_ = SoundEvents.f_144074_;
    }

    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_144074_;
    }

    protected void m_5790_(@NotNull EntityHitResult entityRes) {
        this.applyTamingEffectToSurrounding();
        ArrowsAPI.transformIntoPaddedArrow(this);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        this.applyTamingEffectToSurrounding();
        ArrowsAPI.transformIntoPaddedArrow(this);
    }

    public void applyTamingEffectToSurrounding() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB aABB = this.m_142469_().m_82377_(4.0, 2.0, 4.0);
            List entityList = serverLevel.m_45976_(LivingEntity.class, aABB);
            ArrowsAPI.spawnParticlesInCircle((Level)serverLevel, this.m_20182_(), ParticleTypes.f_123750_, 4.0, 45.0);
            for (LivingEntity livingEntity : entityList) {
                Entity entity;
                TamableAnimal tamableAnimal;
                if (!(livingEntity instanceof TamableAnimal) || (tamableAnimal = (TamableAnimal)livingEntity).m_142480_() != null || !((entity = this.m_37282_()) instanceof Player)) continue;
                Player player = (Player)entity;
                tamableAnimal.m_21828_(player);
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ArrowItems.cupids_arrow);
    }
}

