/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.core.init;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SoundInit {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"beautify");
    public static final RegistryObject<SoundEvent> BOOKSTACK_NEXT = SoundInit.registerSoundEvent("block.bookstack_next");
    public static final RegistryObject<SoundEvent> BOOKSTACK_BREAK = SoundInit.registerSoundEvent("block.bookstack_break");
    public static final RegistryObject<SoundEvent> BOOKSTACK_STEP = SoundInit.registerSoundEvent("block.bookstack_step");
    public static final RegistryObject<SoundEvent> BOOKSTACK_PLACE = SoundInit.registerSoundEvent("block.bookstack_place");
    public static final RegistryObject<SoundEvent> BOOKSTACK_HIT = SoundInit.registerSoundEvent("block.bookstack_hit");
    public static final RegistryObject<SoundEvent> BOOKSTACK_FALL = SoundInit.registerSoundEvent("block.bookstack_fall");
    public static final ForgeSoundType BOOKSTACK_SOUNDS = new ForgeSoundType(1.0f, 1.0f, BOOKSTACK_BREAK, BOOKSTACK_STEP, BOOKSTACK_PLACE, BOOKSTACK_HIT, BOOKSTACK_FALL);
    public static final RegistryObject<SoundEvent> BLINDS_OPEN = SoundInit.registerSoundEvent("block.blinds_open");
    public static final RegistryObject<SoundEvent> BLINDS_CLOSE = SoundInit.registerSoundEvent("block.blinds_close");

    private SoundInit() {
    }

    private static RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> new SoundEvent(new ResourceLocation("beautify", name)));
    }

    public static void register(IEventBus eventBus) {
        SOUND_EVENTS.register(eventBus);
    }
}

