/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import com.github.Pandarix.beautify.core.init.BlockInit;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OakTrellis
extends HorizontalDirectionalBlock {
    private static final List<Item> validFlowers = Arrays.asList(Items.f_41852_, Items.f_42208_, Items.f_42206_, Items.f_42209_, Items.f_42207_, Items.f_42029_, Items.f_41907_, Items.f_41908_, Items.f_151025_);
    public static final IntegerProperty FLOWERS = IntegerProperty.m_61631_((String)"flowers", (int)0, (int)(validFlowers.size() - 1));
    public static final BooleanProperty CEILLING = BooleanProperty.m_61465_((String)"ceilling");
    private static final VoxelShape SHAPE_CEILLING = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);

    public OakTrellis(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CEILLING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43719_() == Direction.DOWN) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)CEILLING, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)CEILLING, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)CEILLING)).booleanValue()) {
            return SHAPE_CEILLING;
        }
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        if (state.m_60713_((Block)BlockInit.OAK_TRELLIS.get()) || state.m_60713_((Block)BlockInit.BIRCH_TRELLIS.get()) || state.m_60713_((Block)BlockInit.JUNGLE_TRELLIS.get()) || state.m_60713_((Block)BlockInit.SPRUCE_TRELLIS.get()) || state.m_60713_((Block)BlockInit.ACACIA_TRELLIS.get()) || state.m_60713_((Block)BlockInit.DARK_OAK_TRELLIS.get()) || state.m_60713_((Block)BlockInit.CRIMSON_TRELLIS.get()) || state.m_60713_((Block)BlockInit.WARPED_TRELLIS.get())) {
            return true;
        }
        return super.isLadder(state, level, pos, entity);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        if (!pLevel.m_5776_() && pHand == InteractionHand.MAIN_HAND) {
            ItemStack playerStack = pPlayer.m_21120_(pHand);
            if ((Integer)pState.m_61143_((Property)FLOWERS) != 0) {
                if (playerStack.m_41619_()) {
                    pPlayer.m_21008_(pHand, new ItemStack((ItemLike)validFlowers.get((Integer)pState.m_61143_((Property)FLOWERS))));
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)FLOWERS, (Comparable)Integer.valueOf(0)), 3);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_144073_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (playerStack.m_150930_(validFlowers.get((Integer)pState.m_61143_((Property)FLOWERS))) && playerStack.m_41613_() < playerStack.m_41741_()) {
                    playerStack.m_41769_(1);
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)FLOWERS, (Comparable)Integer.valueOf(0)), 3);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_144073_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            for (Item flower : validFlowers) {
                if (!playerStack.m_41720_().equals(flower)) continue;
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)FLOWERS, (Comparable)Integer.valueOf(validFlowers.indexOf(flower))), 3);
                if (!flower.equals(Items.f_41852_)) {
                    pLevel.m_5594_(null, pPos, SoundEvents.f_144071_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                playerStack.m_41774_(1);
                return InteractionResult.CONSUME_PARTIAL;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57561_) {
        p_57561_.m_61104_(new Property[]{f_54117_, CEILLING, FLOWERS});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter getter, List<Component> component, TooltipFlag flag) {
        if (!Screen.m_96638_() && !Screen.m_96637_()) {
            component.add((Component)new TranslatableComponent("tooltip.beautify.tooltip.shift").m_130940_(ChatFormatting.YELLOW));
            component.add((Component)new TranslatableComponent("tooltip.beautify.tooltip.plantlist").m_130940_(ChatFormatting.YELLOW));
        }
        if (Screen.m_96638_()) {
            component.add((Component)new TranslatableComponent("tooltip.beautify.trellis.tooltip.info").m_130940_(ChatFormatting.GRAY));
        }
        if (Screen.m_96637_()) {
            component.add((Component)new TranslatableComponent("tooltip.beautify.trellis.tooltip.plant_header").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GRAY));
            component.add((Component)new TranslatableComponent("tooltip.beautify.trellis.tooltip.plants").m_130940_(ChatFormatting.GRAY));
        }
        super.m_5871_(stack, getter, component, flag);
    }
}

