/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.AbstractSizedIngredientRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSortingRecipe
extends AbstractWorktableRecipe {
    private static final Component TITLE = TConstruct.makeTranslation("recipe", "modifier_sorting.title");
    private static final Component DESCRIPTION = TConstruct.makeTranslation("recipe", "modifier_sorting.description");
    private static final Component NOT_ENOUGH_MODIFIERS = TConstruct.makeTranslation("recipe", "modifier_sorting.not_enough_modifiers");

    public ModifierSortingRecipe(ResourceLocation id, List<SizedIngredient> inputs) {
        super(id, inputs);
    }

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public Component getTitle() {
        return TITLE;
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && inv.getTinkerable().getUpgrades().getModifiers().size() < 2) {
            return NOT_ENOUGH_MODIFIERS;
        }
        return DESCRIPTION;
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        ToolStack tool = inv.getTinkerable();
        List<ModifierEntry> upgrades = tool.getUpgrades().getModifiers();
        int toMove = IntStream.range(0, upgrades.size()).filter(i -> ((ModifierEntry)upgrades.get(i)).matches(modifier.getId())).findFirst().orElse(-1);
        if (toMove == -1) {
            return RecipeResult.pass();
        }
        tool = tool.copy();
        ArrayList<ModifierEntry> newUpgrades = new ArrayList<ModifierEntry>(upgrades);
        Collections.swap(newUpgrades, toMove, toMove == upgrades.size() - 1 ? 0 : toMove + 1);
        tool.setUpgrades(new ModifierNBT(newUpgrades));
        return RecipeResult.success(tool);
    }

    @Override
    public int toolResultSize() {
        return 64;
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, boolean isServer) {
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierSortingSerializer.get();
    }

    public static class Builder
    extends AbstractSizedIngredientRecipeBuilder<Builder> {
        public void save(Consumer<FinishedRecipe> consumer) {
            this.save(consumer, Objects.requireNonNull(((ItemStack)((SizedIngredient)this.inputs.get(0)).getMatchingStacks().get(0)).m_41720_().getRegistryName()));
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Must have at least one ingredient");
            }
            ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((FinishedRecipe)new Finished(id, advancementId));
        }

        private Builder() {
        }

        public static Builder sorting() {
            return new Builder();
        }

        private class Finished
        extends AbstractSizedIngredientRecipeBuilder.SizedFinishedRecipe {
            public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
                super(Builder.this, ID, advancementID);
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TinkerModifiers.modifierSortingSerializer.get();
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierSortingRecipe> {
        public ModifierSortingRecipe fromJson(ResourceLocation id, JsonObject json) {
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            return new ModifierSortingRecipe(id, ingredients);
        }

        @Nullable
        public ModifierSortingRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            return new ModifierSortingRecipe(id, (List<SizedIngredient>)builder.build());
        }

        public void toNetworkSafe(FriendlyByteBuf buffer, ModifierSortingRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
        }
    }
}

