/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.worktable.AbstractSizedIngredientRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRemovalRecipe
extends AbstractWorktableRecipe {
    private static final Component TITLE = TConstruct.makeTranslation("recipe", "remove_modifier.title");
    private static final Component DESCRIPTION = TConstruct.makeTranslation("recipe", "remove_modifier.description");
    private static final Component NO_MODIFIERS = TConstruct.makeTranslation("recipe", "remove_modifier.no_modifiers");
    private final SizedIngredient sizedTool;
    private final List<ItemStack> leftovers;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    protected final Predicate<ModifierEntry> entryPredicate;
    private List<ModifierEntry> displayModifiers;

    public ModifierRemovalRecipe(ResourceLocation id, SizedIngredient toolRequirement, List<SizedIngredient> inputs, List<ItemStack> leftovers, IJsonPredicate<ModifierId> modifierPredicate) {
        super(id, Ingredient.f_43901_, inputs);
        this.sizedTool = toolRequirement;
        this.leftovers = leftovers;
        this.modifierPredicate = modifierPredicate;
        this.entryPredicate = mod -> modifierPredicate.matches((Object)mod.getId());
    }

    @Deprecated
    public ModifierRemovalRecipe(ResourceLocation id, List<SizedIngredient> inputs, List<ItemStack> leftovers, IJsonPredicate<ModifierId> modifierPredicate) {
        this(id, SizedIngredient.fromTag(TinkerTags.Items.MODIFIABLE), inputs, leftovers, modifierPredicate);
    }

    @Deprecated
    public ModifierRemovalRecipe(ResourceLocation id, List<SizedIngredient> inputs, List<ItemStack> leftovers) {
        this(id, inputs, leftovers, ModifierPredicate.ALWAYS);
    }

    @Override
    public Component getTitle() {
        return TITLE;
    }

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        if (!this.sizedTool.test(inv.getTinkerableStack())) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    protected List<ModifierEntry> filter(@Nullable IToolStackView tool, List<ModifierEntry> modifiers) {
        if (this.modifierPredicate != ModifierPredicate.ALWAYS) {
            return modifiers.stream().filter(this.entryPredicate).toList();
        }
        return modifiers;
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            if (this.displayModifiers == null) {
                this.displayModifiers = this.filter(null, ModifierRecipeLookup.getRecipeModifierList());
            }
            return this.displayModifiers;
        }
        return this.filter(inv.getTinkerable(), inv.getTinkerable().getUpgrades().getModifiers());
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && inv.getTinkerable().getUpgrades().getModifiers().stream().noneMatch(this.entryPredicate)) {
            return NO_MODIFIERS;
        }
        return DESCRIPTION;
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry entry) {
        ToolStack tool = inv.getTinkerable();
        tool = tool.copy();
        ModifierId modifierId = entry.getId();
        ModifierSalvage salvage = ModifierRecipeLookup.getSalvage(inv.getTinkerableStack(), tool, modifierId, entry.getLevel());
        if (salvage != null) {
            salvage.updateTool(tool);
        }
        int newLevel = tool.getModifierLevel(modifierId) - 1;
        Modifier modifier = entry.getModifier();
        if (newLevel <= 0) {
            modifier.getHook(TinkerHooks.RAW_DATA).removeRawData(tool, modifier, tool.getRestrictedNBT());
        }
        tool.removeModifier(modifierId, 1);
        Component error = tool.tryValidate();
        if (error != null) {
            return RecipeResult.failure(error);
        }
        if (newLevel <= 0 && (error = modifier.getHook(TinkerHooks.REMOVE).onRemoved(tool, modifier)) != null) {
            return RecipeResult.failure(error);
        }
        ValidatedResult validated = ModifierRecipeLookup.checkRequirements(inv.getTinkerableStack(), tool);
        if (validated.hasError()) {
            return RecipeResult.failure(validated.getMessage());
        }
        return RecipeResult.success(tool);
    }

    @Override
    public int toolResultSize() {
        return 64;
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, boolean isServer) {
        super.updateInputs(result, inv, isServer);
        if (isServer) {
            for (ItemStack stack : this.leftovers) {
                inv.giveItem(stack.m_41777_());
            }
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.removeModifierSerializer.get();
    }

    @Override
    public List<ItemStack> getInputTools() {
        if (this.tools == null) {
            this.tools = this.sizedTool.getMatchingStacks().stream().map(stack -> {
                ItemStack tool = IModifiableDisplay.getDisplayStack(stack.m_41720_());
                if (stack.m_41613_() > 1) {
                    tool = ItemHandlerHelper.copyStackWithSize((ItemStack)tool, (int)stack.m_41613_());
                }
                return tool;
            }).toList();
        }
        return this.tools;
    }

    public static class Builder
    extends AbstractSizedIngredientRecipeBuilder<Builder> {
        private final RecipeSerializer<? extends ModifierRemovalRecipe> serializer;
        private final List<ItemStack> leftovers = new ArrayList<ItemStack>();
        private SizedIngredient tools = SizedIngredient.EMPTY;
        private IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ALWAYS;

        public static Builder removal() {
            return Builder.removal((RecipeSerializer<? extends ModifierRemovalRecipe>)((RecipeSerializer)TinkerModifiers.removeModifierSerializer.get()));
        }

        public Builder setTools(SizedIngredient ingredient) {
            this.tools = ingredient;
            return this;
        }

        public Builder setTools(Ingredient ingredient) {
            return this.setTools(SizedIngredient.of((Ingredient)ingredient));
        }

        public Builder addLeftover(ItemStack stack) {
            this.leftovers.add(stack);
            return this;
        }

        public Builder addLeftover(ItemLike item) {
            return this.addLeftover(new ItemStack(item));
        }

        public void save(Consumer<FinishedRecipe> consumer) {
            this.save(consumer, Objects.requireNonNull(this.leftovers.get(0).m_41720_().getRegistryName()));
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Must have at least one input");
            }
            ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((FinishedRecipe)new Finished(id, advancementId));
        }

        private Builder(RecipeSerializer<? extends ModifierRemovalRecipe> serializer) {
            this.serializer = serializer;
        }

        public static Builder removal(RecipeSerializer<? extends ModifierRemovalRecipe> serializer) {
            return new Builder(serializer);
        }

        public Builder modifierPredicate(IJsonPredicate<ModifierId> modifierPredicate) {
            this.modifierPredicate = modifierPredicate;
            return this;
        }

        private class Finished
        extends AbstractSizedIngredientRecipeBuilder.SizedFinishedRecipe {
            public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
                super(Builder.this, ID, advancementID);
            }

            @Override
            public void m_7917_(JsonObject json) {
                super.m_7917_(json);
                SizedIngredient ingredient = Builder.this.tools;
                if (ingredient == SizedIngredient.EMPTY) {
                    ingredient = SizedIngredient.fromTag(TinkerTags.Items.MODIFIABLE);
                }
                json.add("tools", (JsonElement)ingredient.serialize());
                if (!Builder.this.leftovers.isEmpty()) {
                    JsonArray array = new JsonArray();
                    for (ItemStack stack : Builder.this.leftovers) {
                        array.add(JsonUtils.serializeItemStack(stack));
                    }
                    json.add("leftovers", (JsonElement)array);
                }
                json.add("modifier_predicate", ModifierPredicate.LOADER.serialize(Builder.this.modifierPredicate));
            }

            public RecipeSerializer<?> m_6637_() {
                return Builder.this.serializer;
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierRemovalRecipe> {
        private final Factory factory;

        @Deprecated
        public Serializer(ModifierRemovalRecipeFactory factory) {
            this((Factory)factory);
        }

        public ModifierRemovalRecipe fromJson(ResourceLocation id, JsonObject json) {
            SizedIngredient tool = json.has("tools") ? SizedIngredient.deserialize((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"tools")) : SizedIngredient.fromTag(TinkerTags.Items.MODIFIABLE);
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            List leftovers = Collections.emptyList();
            if (json.has("leftovers")) {
                leftovers = JsonHelper.parseList((JsonObject)json, (String)"leftovers", JsonUtils::convertToItemStack);
            }
            ModifierPredicate modifierPredicate = ModifierPredicate.ALWAYS;
            if (json.has("modifier_predicate")) {
                modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.getAndDeserialize(json, "modifier_predicate");
            }
            return this.factory.create(id, tool, ingredients, leftovers, modifierPredicate);
        }

        @Nullable
        public ModifierRemovalRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            SizedIngredient tool = SizedIngredient.read((FriendlyByteBuf)buffer);
            int size = buffer.m_130242_();
            ImmutableList.Builder ingredients = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            size = buffer.m_130242_();
            ImmutableList.Builder leftovers = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                leftovers.add((Object)buffer.m_130267_());
            }
            IJsonPredicate modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.fromNetwork(buffer);
            return this.factory.create(id, tool, (List<SizedIngredient>)ingredients.build(), (List<ItemStack>)leftovers.build(), (IJsonPredicate<ModifierId>)modifierPredicate);
        }

        public void toNetworkSafe(FriendlyByteBuf buffer, ModifierRemovalRecipe recipe) {
            recipe.sizedTool.write(buffer);
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.m_130130_(recipe.leftovers.size());
            for (ItemStack itemStack : recipe.leftovers) {
                buffer.m_130055_(itemStack);
            }
            ModifierPredicate.LOADER.toNetwork(recipe.modifierPredicate, buffer);
        }

        public Serializer(Factory factory) {
            this.factory = factory;
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public ModifierRemovalRecipe create(ResourceLocation var1, SizedIngredient var2, List<SizedIngredient> var3, List<ItemStack> var4, IJsonPredicate<ModifierId> var5);
    }

    @Deprecated
    @FunctionalInterface
    public static interface ModifierRemovalRecipeFactory
    extends Factory {
        public ModifierRemovalRecipe create(ResourceLocation var1, List<SizedIngredient> var2, List<ItemStack> var3, IJsonPredicate<ModifierId> var4);

        @Override
        default public ModifierRemovalRecipe create(ResourceLocation id, SizedIngredient toolRequirement, List<SizedIngredient> inputs, List<ItemStack> leftovers, IJsonPredicate<ModifierId> modifierPredicate) {
            return this.create(id, inputs, leftovers, modifierPredicate);
        }
    }
}

