/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.worktable.AbstractSizedIngredientRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;

public class EnchantmentConvertingRecipe
extends AbstractWorktableRecipe {
    private static final String BASE_KEY = TConstruct.makeTranslationKey("recipe", "enchantment_converting");
    private static final Component DESCRIPTION_LOST = TConstruct.makeTranslation("recipe", "enchantment_converting.description.lost");
    private static final Component DESCRIPTION_KEEP = TConstruct.makeTranslation("recipe", "enchantment_converting.description.keep");
    private static final Component NO_ENCHANTMENT = TConstruct.makeTranslation("recipe", "enchantment_converting.no_enchantments");
    private static final RecipeResult<ToolStack> TOO_FEW = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "enchantment_converting.too_few"), new Object[0]);
    private final String name;
    private final Component title;
    private final boolean matchBook;
    private final boolean returnInput;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    private List<ModifierEntry> displayModifiers;
    private static List<ItemStack> ALL_ENCHANTABLE_TOOLS;

    public EnchantmentConvertingRecipe(ResourceLocation id, String name, List<SizedIngredient> inputs, boolean matchBook, boolean returnInput, IJsonPredicate<ModifierId> modifierPredicate) {
        super(id, inputs);
        this.name = name;
        this.title = new TranslatableComponent(BASE_KEY + "." + name + ".title");
        this.matchBook = matchBook;
        this.returnInput = returnInput;
        this.modifierPredicate = modifierPredicate;
    }

    private Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        return EnchantmentHelper.m_44882_((ListTag)(this.matchBook ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_()));
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && this.getEnchantments(inv.getTinkerableStack()).entrySet().stream().noneMatch(entry -> {
            Modifier modifier = ModifierManager.INSTANCE.get((Enchantment)entry.getKey());
            return modifier != null && this.modifierPredicate.matches((Object)modifier.getId());
        })) {
            return NO_ENCHANTMENT;
        }
        return this.returnInput ? DESCRIPTION_KEEP : DESCRIPTION_LOST;
    }

    @Override
    public boolean matches(ITinkerableContainer inv, Level world) {
        ItemStack tool = inv.getTinkerableStack();
        if (this.matchBook ? !tool.m_150930_(Items.f_42690_) : !tool.m_41720_().m_8120_(tool)) {
            return false;
        }
        return ModifierRecipe.checkMatch(inv, this.inputs);
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv != null) {
            return this.getEnchantments(inv.getTinkerableStack()).entrySet().stream().map(entry -> {
                Modifier modifier = ModifierManager.INSTANCE.get((Enchantment)entry.getKey());
                if (modifier != null && this.modifierPredicate.matches((Object)modifier.getId())) {
                    return new ModifierEntry(modifier, (int)((Integer)entry.getValue()));
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        if (this.displayModifiers == null) {
            this.displayModifiers = ModifierRecipeLookup.getAllRecipeModifiers().filter(modifier -> this.modifierPredicate.matches((Object)modifier.getId())).map(mod -> new ModifierEntry((Modifier)mod, 1)).toList();
        }
        return this.displayModifiers;
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        int level = modifier.getLevel();
        if (level > 1) {
            int used = -1;
            block0: for (SizedIngredient ingredient : this.inputs) {
                for (int i = 0; i < inv.getInputCount(); ++i) {
                    ItemStack stack;
                    if (i == used || (stack = inv.getInput(i)).m_41619_() || ingredient.getAmountNeeded() * level > stack.m_41613_() || !ingredient.test(stack)) continue;
                    used = i;
                    continue block0;
                }
                return TOO_FEW;
            }
        }
        return RecipeResult.success(ToolStack.from(ModifierCrystalItem.withModifier(modifier.getId())));
    }

    @Override
    public int toolResultSize(ITinkerableContainer inv, ModifierEntry selected) {
        return selected.getLevel();
    }

    @Override
    public void updateInputs(IToolStackView result, ITinkerableContainer.Mutable inv, ModifierEntry selected, boolean isServer) {
        for (int i = 0; i < selected.getLevel(); ++i) {
            ModifierRecipe.updateInputs(inv, this.inputs);
        }
        if (this.returnInput && isServer) {
            ItemStack unenchanted;
            ItemStack current = inv.getTinkerableStack();
            if (this.matchBook) {
                unenchanted = new ItemStack((ItemLike)Items.f_42517_);
                if (current.m_41788_()) {
                    unenchanted.m_41714_(current.m_41786_());
                }
            } else {
                unenchanted = current.m_41777_();
                EnchantmentHelper.m_44865_(this.getEnchantments(unenchanted).entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), (ItemStack)unenchanted);
            }
            inv.giveItem(unenchanted);
        }
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.enchantmentConvertingSerializer.get();
    }

    @Override
    public boolean isModifierOutput() {
        return true;
    }

    @Override
    public List<ItemStack> getInputTools() {
        if (!this.matchBook) {
            return EnchantmentConvertingRecipe.getAllEnchantableTools();
        }
        if (this.tools == null) {
            Set modifiers = this.getModifierOptions(null).stream().map(ModifierEntry::getId).collect(Collectors.toSet());
            this.tools = ModifierManager.INSTANCE.getEquivalentEnchantments(modifiers::contains).flatMap(enchantment -> IntStream.rangeClosed(1, enchantment.m_6586_()).mapToObj(level -> EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level)))).toList();
        }
        return this.tools;
    }

    private static List<ItemStack> getAllEnchantableTools() {
        if (ALL_ENCHANTABLE_TOOLS == null) {
            ALL_ENCHANTABLE_TOOLS = ForgeRegistries.ITEMS.getValues().stream().map(item -> {
                ItemStack stack;
                if (item != Items.f_42517_ && (stack = new ItemStack((ItemLike)item)).m_41792_()) {
                    return stack;
                }
                return ItemStack.f_41583_;
            }).filter(stack -> !stack.m_41619_()).toList();
        }
        return ALL_ENCHANTABLE_TOOLS;
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    public static class Builder
    extends AbstractSizedIngredientRecipeBuilder<Builder> {
        private final String name;
        private final boolean matchBook;
        private boolean returnInput = false;
        private IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ALWAYS;

        public Builder returnInput() {
            this.returnInput = true;
            return this;
        }

        public void save(Consumer<FinishedRecipe> consumer) {
            this.save(consumer, TConstruct.getResource(this.name));
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("Must have at least one input");
            }
            ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((FinishedRecipe)new Finished(id, advancementId));
        }

        private Builder(String name, boolean matchBook) {
            this.name = name;
            this.matchBook = matchBook;
        }

        public static Builder converting(String name, boolean matchBook) {
            return new Builder(name, matchBook);
        }

        public Builder modifierPredicate(IJsonPredicate<ModifierId> modifierPredicate) {
            this.modifierPredicate = modifierPredicate;
            return this;
        }

        private class Finished
        extends AbstractSizedIngredientRecipeBuilder.SizedFinishedRecipe {
            public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
                super(Builder.this, ID, advancementID);
            }

            @Override
            public void m_7917_(JsonObject json) {
                json.addProperty("name", Builder.this.name);
                super.m_7917_(json);
                json.addProperty("match_book", Boolean.valueOf(Builder.this.matchBook));
                json.addProperty("return_unenchanted", Boolean.valueOf(Builder.this.returnInput));
                json.add("modifier_predicate", ModifierPredicate.LOADER.serialize(Builder.this.modifierPredicate));
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TinkerModifiers.enchantmentConvertingSerializer.get();
            }
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<EnchantmentConvertingRecipe> {
        public EnchantmentConvertingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            boolean matchBook = GsonHelper.m_13912_((JsonObject)json, (String)"match_book");
            boolean returnInput = GsonHelper.m_13912_((JsonObject)json, (String)"return_unenchanted");
            IJsonPredicate modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.getAndDeserialize(json, "modifier_predicate");
            return new EnchantmentConvertingRecipe(id, name, ingredients, matchBook, returnInput, (IJsonPredicate<ModifierId>)modifierPredicate);
        }

        @Nullable
        public EnchantmentConvertingRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            String name = buffer.m_130136_(Short.MAX_VALUE);
            int size = buffer.m_130242_();
            ImmutableList.Builder ingredients = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            boolean matchBook = buffer.readBoolean();
            boolean returnInput = buffer.readBoolean();
            IJsonPredicate modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.fromNetwork(buffer);
            return new EnchantmentConvertingRecipe(id, name, (List<SizedIngredient>)ingredients.build(), matchBook, returnInput, (IJsonPredicate<ModifierId>)modifierPredicate);
        }

        public void toNetworkSafe(FriendlyByteBuf buffer, EnchantmentConvertingRecipe recipe) {
            buffer.m_130070_(recipe.name);
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.writeBoolean(recipe.matchBook);
            buffer.writeBoolean(recipe.returnInput);
            ModifierPredicate.LOADER.toNetwork(recipe.modifierPredicate, buffer);
        }
    }
}

