/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.general;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.Lazy;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.shared.TinkerCommons;

public class TastyModifier
extends Modifier
implements GeneralInteractionModifierHook {
    private static final Lazy<ItemStack> BACON_STACK = Lazy.of(() -> new ItemStack(TinkerCommons.bacon));

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CHARGEABLE_INTERACT);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && !tool.isBroken() && player.m_36391_(false)) {
            ModifierUtil.startUsingItem(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        Player player;
        ModDataNBT persistentData = tool.getPersistentData();
        if (!tool.isBroken() && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
            int level = modifier.getLevel();
            Level world = entity.m_183503_();
            player.m_36324_().m_38707_(level, (float)level * 0.1f);
            ModifierUtil.foodConsumer.onConsume(player, (ItemStack)BACON_STACK.get(), level, (float)level * 0.1f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.4f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 0.5f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
            if (ToolDamageUtil.directDamage(tool, 15 * level, (LivingEntity)player, player.m_21211_())) {
                player.m_21190_(player.m_7655_());
            }
            return true;
        }
        return false;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.EAT;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 16;
    }

    @Override
    public List<ItemStack> processLoot(IToolStackView tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81457_)) {
            return generatedLoot;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity != null && entity.m_6095_().m_204039_(TinkerTags.EntityTypes.BACON_PRODUCER)) {
            int looting = context.getLootingModifier();
            if (RANDOM.nextInt(48 / level) <= looting) {
                generatedLoot.add(new ItemStack(TinkerCommons.bacon));
            }
        }
        return generatedLoot;
    }
}

