/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.layout.Patterns;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class ToolContainerScreen
extends AbstractContainerScreen<ToolContainerMenu> {
    private static final ResourceLocation TEXTURE = TConstruct.getResource("textures/gui/tool.png");
    private static final int REPEAT_BACKGROUND_ROWS = 6;
    private static final int PLAYER_INVENTORY_START = 125;
    private static final int PLAYER_INVENTORY_HEIGHT = 97;
    private static final int SLOTS_START = 238;
    private static final int SELECTED_X = 176;
    private final int slots;
    private final int inventoryRows;
    private final int slotsInLastRow;
    private final IToolStackView tool;

    public ToolContainerScreen(ToolContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        int slots = menu.getItemHandler().getSlots();
        if (menu.isShowOffhand()) {
            ++slots;
        }
        int inventoryRows = slots / 9;
        int slotsInLastRow = slots % 9;
        if (slotsInLastRow == 0) {
            slotsInLastRow = 9;
        } else {
            ++inventoryRows;
        }
        this.slots = slots;
        this.inventoryRows = inventoryRows;
        this.slotsInLastRow = slotsInLastRow;
        this.f_97727_ = 114 + this.inventoryRows * 18;
        this.f_97731_ = this.f_97727_ - 94;
        this.tool = ToolStack.from(menu.getStack());
    }

    protected void m_6597_(Slot slot, int slotId, int index, ClickType type) {
        EquipmentSlot toolSlot;
        if (type == ClickType.SWAP && ((toolSlot = ((ToolContainerMenu)this.f_97732_).getSlotType()) == EquipmentSlot.MAINHAND && index == ((ToolContainerMenu)this.f_97732_).getSelectedHotbarSlot() || toolSlot == EquipmentSlot.OFFHAND && index == 40)) {
            return;
        }
        super.m_6597_(slot, slotId, index, type);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        Slot slot;
        int yOffset;
        RenderUtils.setup(TEXTURE);
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        if (this.inventoryRows <= 6) {
            yOffset = this.inventoryRows * 18 + 17;
            this.m_93228_(matrixStack, xStart, yStart, 0, 0, this.f_97726_, yOffset);
        } else {
            int remaining;
            yOffset = 125;
            this.m_93228_(matrixStack, xStart, yStart, 0, 0, this.f_97726_, yOffset);
            int height = 108;
            for (remaining = this.inventoryRows - 6; remaining > 6; remaining -= 6) {
                this.m_93228_(matrixStack, xStart, yStart + yOffset, 0, 17, this.f_97726_, height);
                yOffset += height;
            }
            height = remaining * 18;
            this.m_93228_(matrixStack, xStart, yStart + yOffset, 0, 17, this.f_97726_, height);
            yOffset += height;
        }
        this.m_93228_(matrixStack, xStart, yStart + yOffset, 0, 125, this.f_97726_, 97);
        int rowLeft = xStart + 7;
        int rowStart = yStart + 17 - 18;
        for (int i = 1; i < this.inventoryRows; ++i) {
            this.m_93228_(matrixStack, rowLeft, rowStart + i * 18, 0, 238, 162, 18);
        }
        this.m_93228_(matrixStack, rowLeft, rowStart + this.inventoryRows * 18, 0, 238, this.slotsInLastRow * 18, 18);
        int selectedSlot = ((ToolContainerMenu)this.f_97732_).getSelectedHotbarSlot();
        if (selectedSlot != -1) {
            int slotIndex = this.slots - 1;
            if (selectedSlot != 10) {
                slotIndex += 28 + selectedSlot;
            }
            if (slotIndex < ((ToolContainerMenu)this.f_97732_).f_38839_.size()) {
                Slot slot2 = ((ToolContainerMenu)this.f_97732_).m_38853_(slotIndex);
                this.m_93228_(matrixStack, xStart + slot2.f_40220_ - 2, yStart + slot2.f_40221_ - 2, 176, 0, 20, 20);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        assert (this.f_96541_ != null);
        Function spriteGetter = this.f_96541_.m_91258_(InventoryMenu.f_39692_);
        int start = 0;
        int maxSlots = ((ToolContainerMenu)this.f_97732_).f_38839_.size();
        List<ModifierEntry> modifiers = this.tool.getModifierList();
        block2: for (int modIndex = modifiers.size() - 1; modIndex >= 0; --modIndex) {
            ModifierEntry entry = modifiers.get(modIndex);
            ToolInventoryCapability.InventoryModifierHook inventory = entry.getHook(ToolInventoryCapability.HOOK);
            int size = inventory.getSlots(this.tool, entry);
            for (int i = 0; i < size; ++i) {
                if (start + i >= maxSlots) break block2;
                Slot slot3 = ((ToolContainerMenu)this.f_97732_).m_38853_(start + i);
                Pattern pattern = inventory.getPattern(this.tool, entry, i, slot3.m_6657_());
                if (pattern == null) continue;
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(pattern.getTexture());
                ToolContainerScreen.m_93200_((PoseStack)matrixStack, (int)(xStart + slot3.f_40220_), (int)(yStart + slot3.f_40221_), (int)100, (int)16, (int)16, (TextureAtlasSprite)sprite);
            }
            start += size;
        }
        if (((ToolContainerMenu)this.f_97732_).isShowOffhand() && !(slot = ((ToolContainerMenu)this.f_97732_).m_38853_(this.slots - 1)).m_6657_()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(Patterns.SHIELD.getTexture());
            ToolContainerScreen.m_93200_((PoseStack)matrixStack, (int)(xStart + slot.f_40220_), (int)(yStart + slot.f_40221_), (int)100, (int)16, (int)16, (TextureAtlasSprite)sprite);
        }
    }
}

