/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tables.TinkerTables;

public class TinkerStationPartSwapping
implements ITinkerStationRecipe {
    private static final ValidatedResult TOO_MANY_PARTS = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "part_swapping.too_many_parts"), new Object[0]);
    protected final ResourceLocation id;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (tinkerable.m_41619_() || !tinkerable.m_204117_(TinkerTags.Items.MULTIPART_TOOL) || !(tinkerable.m_41720_() instanceof IModifiable)) {
            return false;
        }
        List<PartRequirement> parts = ((IModifiable)tinkerable.m_41720_()).getToolDefinition().getData().getParts();
        if (parts.isEmpty()) {
            return false;
        }
        boolean foundItem = false;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (foundItem) {
                return false;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof IToolPart) || parts.stream().noneMatch(p -> p.matches(item))) {
                return false;
            }
            foundItem = true;
        }
        return foundItem;
    }

    @Deprecated
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = inv.getTinkerable();
        List<PartRequirement> parts = tool.getDefinition().getData().getParts();
        if (parts.size() > inv.getInputCount()) {
            return TOO_MANY_PARTS;
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack result;
            ValidatedResult toolValidation;
            int cost;
            IRepairableMaterialStats r;
            IRepairableMaterialStats repairable;
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (!(item instanceof IToolPart)) {
                return ValidatedResult.PASS;
            }
            IToolPart part = (IToolPart)item;
            MaterialVariantId partVariant = part.getMaterial(stack);
            if (partVariant.equals(IMaterial.UNKNOWN_ID)) {
                return ValidatedResult.PASS;
            }
            int index = i;
            if (!(i < parts.size() && parts.get(i).matches(item) || (index = IntStream.range(0, parts.size()).filter(pi -> ((PartRequirement)parts.get(pi)).matches(item)).findFirst().orElse(-1)) != -1)) {
                return ValidatedResult.PASS;
            }
            MaterialVariant toolVariant = tool.getMaterial(index);
            boolean didChange = !toolVariant.sameVariant(partVariant);
            IMaterialStats stats = MaterialRegistry.getInstance().getMaterialStats(partVariant.getId(), part.getStatType()).orElse(null);
            IRepairableMaterialStats iRepairableMaterialStats = repairable = stats instanceof IRepairableMaterialStats ? (r = (IRepairableMaterialStats)stats) : null;
            if (!(didChange || tool.getDamage() != 0 && repairable != null)) {
                return ValidatedResult.PASS;
            }
            tool = tool.copy();
            List<Modifier> actuallyRemoved = Collections.emptyList();
            if (didChange) {
                Modifier modifier;
                HashMap<Modifier, Integer> removedTraits = new HashMap<Modifier, Integer>();
                for (ModifierEntry modifierEntry : MaterialRegistry.getInstance().getTraits(toolVariant.getId(), part.getStatType())) {
                    removedTraits.put(modifierEntry.getModifier(), modifierEntry.getLevel());
                }
                for (ModifierEntry modifierEntry : MaterialRegistry.getInstance().getTraits(partVariant.getId(), part.getStatType())) {
                    modifier = modifierEntry.getModifier();
                    if (!removedTraits.containsKey(modifier)) continue;
                    int value = (Integer)removedTraits.get(modifier) - modifierEntry.getLevel();
                    if (value <= 0) {
                        removedTraits.remove(modifier);
                        continue;
                    }
                    removedTraits.put(modifier, value);
                }
                actuallyRemoved = new ArrayList<Modifier>();
                for (Map.Entry entry : removedTraits.entrySet()) {
                    modifier = (Modifier)entry.getKey();
                    if (tool.getModifierLevel(modifier) > (Integer)entry.getValue()) continue;
                    modifier.getHook(TinkerHooks.RAW_DATA).removeRawData(tool, modifier, tool.getRestrictedNBT());
                    actuallyRemoved.add(modifier);
                }
                tool.replaceMaterial(index, partVariant);
            }
            if (repairable != null && (cost = MaterialCastingLookup.getItemCost(part)) > 0) {
                ModifierEntry entry;
                float factor = (float)cost / 3.0f;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((factor = (entry = iterator.next()).getHook(TinkerHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, factor)) <= 0.0f)) {
                }
                if (factor > 0.0f) {
                    ToolDamageUtil.repair(tool, (int)((float)repairable.getDurability() * factor));
                }
            }
            if ((toolValidation = ModifierRecipeLookup.checkRequirements(result = tool.createStack(Math.min(inv.getTinkerableSize(), this.shrinkToolSlotBy())), tool)).hasError()) {
                return toolValidation;
            }
            Component component = tool.tryValidate();
            if (component != null) {
                return ValidatedResult.failure(component);
            }
            for (Modifier modifier : actuallyRemoved) {
                Component component2 = modifier.getHook(TinkerHooks.REMOVE).onRemoved(tool, modifier);
                if (component2 == null) continue;
                return ValidatedResult.failure(component2);
            }
            return ValidatedResult.success(result);
        }
        return ValidatedResult.PASS;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.tinkerStationPartSwappingSerializer.get();
    }

    public TinkerStationPartSwapping(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

