/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public class CopperCanFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    private final ItemStack container;

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int getTankCapacity(int tank) {
        return 90;
    }

    private Fluid getFluid() {
        return CopperCanItem.getFluid(this.container);
    }

    @Nullable
    private CompoundTag getFluidTag() {
        return CopperCanItem.getFluidTag(this.container);
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(this.getFluid(), 90, this.getFluidTag());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getFluid() != Fluids.f_76191_ || resource.getAmount() < 90) {
            return 0;
        }
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, resource);
        }
        return 90;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || resource.getAmount() < 90) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_ || fluid != resource.getFluid()) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, 90, this.getFluidTag());
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, FluidStack.EMPTY);
        }
        return output;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain < 90) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.f_76191_) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, 90, this.getFluidTag());
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, FluidStack.EMPTY);
        }
        return output;
    }

    public CopperCanFluidHandler(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

