/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.inventory;

import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.recipe.fuel.IFluidContainer;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;

public class MelterFuelWrapper
implements IFluidContainer {
    private final WeakReference<IFluidTank> tank;

    public MelterFuelWrapper(IFluidTank tank) {
        this.tank = new WeakReference<IFluidTank>(tank);
    }

    public boolean isValid() {
        return this.tank.get() != null;
    }

    @Override
    public Fluid getFluid() {
        return Optional.ofNullable((IFluidTank)this.tank.get()).map(IFluidTank::getFluid).map(FluidStack::getFluid).orElse(Fluids.f_76191_);
    }

    public FluidStack getFluidStack() {
        return Optional.ofNullable((IFluidTank)this.tank.get()).map(IFluidTank::getFluid).orElse(FluidStack.EMPTY);
    }

    public int getCapacity() {
        return Optional.ofNullable((IFluidTank)this.tank.get()).map(IFluidTank::getCapacity).orElse(0);
    }

    public int consumeFuel(MeltingFuel fuel) {
        int amount;
        IFluidTank tank = (IFluidTank)this.tank.get();
        if (tank != null && (amount = fuel.getAmount(this)) > 0) {
            int drained = tank.drain(amount, IFluidHandler.FluidAction.EXECUTE).getAmount();
            int duration = fuel.getDuration();
            if (drained < amount) {
                return duration * drained / amount;
            }
            return duration;
        }
        return 0;
    }
}

