/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryInputOutputBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;

public class DrainBlockEntity
extends SmelteryInputOutputBlockEntity.SmelteryFluidIO
implements IDisplayFluidListener {
    private FluidStack displayFluid = FluidStack.EMPTY;

    public DrainBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerSmeltery.drain.get(), pos, state);
    }

    protected DrainBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void notifyDisplayFluidUpdated(FluidStack fluid) {
        if (!fluid.isFluidEqual(this.displayFluid)) {
            this.displayFluid = fluid;
            this.getModelData().setData(IDisplayFluidListener.PROPERTY, (Object)this.displayFluid);
            this.requestModelDataUpdate();
            assert (this.f_58857_ != null);
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.f_58858_, state, state, 48);
        }
    }

    @Override
    public BlockPos getListenerPos() {
        return this.m_58899_();
    }

    private void attachFluidListener() {
        BlockPos masterPos = this.getMasterPos();
        if (masterPos != null && this.f_58857_ != null && this.f_58857_.f_46443_) {
            BlockEntityHelper.get(ISmelteryTankHandler.class, (BlockGetter)this.f_58857_, (BlockPos)masterPos).ifPresent(te -> te.addDisplayListener(this));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeMaster(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        BlockPos oldMaster = this.getMasterPos();
        super.handleUpdateTag(tag);
        if (!Objects.equals(oldMaster, this.getMasterPos())) {
            this.attachFluidListener();
        }
    }

    @Override
    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            BlockPos oldMaster = this.getMasterPos();
            this.m_142466_(tag);
            if (!Objects.equals(oldMaster, this.getMasterPos())) {
                this.attachFluidListener();
            }
        }
    }

    public FluidStack getDisplayFluid() {
        return this.displayFluid;
    }
}

