/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialNBT {
    public static final MaterialNBT EMPTY = new MaterialNBT((List<MaterialVariant>)ImmutableList.of());
    private final List<MaterialVariant> list;

    public MaterialNBT(List<MaterialVariant> list) {
        this.list = ImmutableList.copyOf(list);
    }

    @VisibleForTesting
    public static MaterialNBT of(IMaterial ... materials) {
        return new MaterialNBT(Arrays.stream(materials).map(MaterialVariant::of).toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public MaterialVariant get(int index) {
        if (index >= this.list.size() || index < 0) {
            return MaterialVariant.UNKNOWN;
        }
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public MaterialNBT replaceMaterial(int index, MaterialVariantId replacement) {
        int i;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Material index is out of bounds");
        }
        int size = this.list.size();
        ArrayList<MaterialVariant> list = new ArrayList<MaterialVariant>(Math.max(size, index + 1));
        for (i = 0; i < size; ++i) {
            if (i == index) {
                list.add(MaterialVariant.of(replacement));
                continue;
            }
            list.add(this.list.get(i));
        }
        if (index >= size) {
            for (i = size; i < index; ++i) {
                list.add(MaterialVariant.of(IMaterial.UNKNOWN, ""));
            }
            list.add(MaterialVariant.of(replacement));
        }
        return new MaterialNBT(list);
    }

    public static MaterialNBT readFromNBT(@Nullable Tag nbt) {
        if (nbt == null || nbt.m_7060_() != 9) {
            return EMPTY;
        }
        ListTag listNBT = (ListTag)nbt;
        if (listNBT.m_7264_() != 8) {
            return EMPTY;
        }
        List<MaterialVariant> materials = listNBT.stream().map(tag -> MaterialVariantId.tryParse(tag.m_7916_())).filter(Objects::nonNull).map(MaterialVariant::of).collect(Collectors.toList());
        return new MaterialNBT(materials);
    }

    public ListTag serializeToNBT() {
        return this.list.stream().map(lazy -> StringTag.m_129297_((String)lazy.getVariant().toString())).collect(Collectors.toCollection(ListTag::new));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialNBT)) {
            return false;
        }
        MaterialNBT other = (MaterialNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MaterialVariant> this$list = this.getList();
        List<MaterialVariant> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MaterialVariant> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialNBT(list=" + this.getList() + ")";
    }

    public List<MaterialVariant> getList() {
        return this.list;
    }

    public static class Builder {
        private final ImmutableList.Builder<MaterialVariant> builder = ImmutableList.builder();

        public Builder add(MaterialVariant variant) {
            this.builder.add((Object)variant);
            return this;
        }

        public Builder add(MaterialVariantId variantId) {
            return this.add(MaterialVariant.of(variantId));
        }

        public Builder add(IMaterial material) {
            return this.add(MaterialVariant.of(material));
        }

        public MaterialNBT build() {
            return new MaterialNBT((List<MaterialVariant>)this.builder.build());
        }
    }
}

