/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public interface IToolContext {
    public Item getItem();

    public ToolDefinition getDefinition();

    public StatsNBT getStats();

    default public ToolDefinitionData getDefinitionData() {
        return this.getDefinition().getData();
    }

    default public boolean hasTag(TagKey<Item> tag) {
        return this.getItem().m_204114_().containsTag(tag);
    }

    public MaterialNBT getMaterials();

    default public MaterialVariant getMaterial(int index) {
        return this.getMaterials().get(index);
    }

    public ModifierNBT getUpgrades();

    public ModifierNBT getModifiers();

    default public List<ModifierEntry> getModifierList() {
        return this.getModifiers().getModifiers();
    }

    default public int getModifierLevel(ModifierId modifier) {
        return this.getModifiers().getLevel(modifier);
    }

    default public int getModifierLevel(Modifier modifier) {
        return this.getModifiers().getLevel(modifier.getId());
    }

    public IModDataView getPersistentData();

    public IModDataView getVolatileData();
}

