/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.severing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class AgeableSeveringRecipe
extends SeveringRecipe {
    @Nullable
    private final ItemOutput childOutput;

    public AgeableSeveringRecipe(ResourceLocation id, EntityIngredient ingredient, ItemOutput adultOutput, @Nullable ItemOutput childOutput) {
        super(id, ingredient, adultOutput);
        this.childOutput = childOutput;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.ageableSeveringSerializer.get();
    }

    @Override
    public ItemStack getOutput(Entity entity) {
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6162_()) {
            return this.childOutput == null ? ItemStack.f_41583_ : this.childOutput.get().m_41777_();
        }
        return this.getOutput().m_41777_();
    }

    public static class Serializer
    extends LoggingRecipeSerializer<AgeableSeveringRecipe> {
        public AgeableSeveringRecipe fromJson(ResourceLocation id, JsonObject json) {
            EntityIngredient ingredient = EntityIngredient.deserialize((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"entity"));
            ItemOutput adult = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"adult_result"));
            ItemOutput child = null;
            if (json.has("child_result")) {
                child = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"child_result"));
            }
            return new AgeableSeveringRecipe(id, ingredient, adult, child);
        }

        @Nullable
        protected AgeableSeveringRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            EntityIngredient ingredient = EntityIngredient.read((FriendlyByteBuf)buffer);
            ItemOutput adult = ItemOutput.read((FriendlyByteBuf)buffer);
            ItemOutput child = null;
            if (buffer.readBoolean()) {
                child = ItemOutput.read((FriendlyByteBuf)buffer);
            }
            return new AgeableSeveringRecipe(id, ingredient, adult, child);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, AgeableSeveringRecipe recipe) {
            recipe.ingredient.write(buffer);
            recipe.output.write(buffer);
            if (recipe.childOutput == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                recipe.childOutput.write(buffer);
            }
        }
    }
}

