/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.DisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MultilevelModifierRecipe
extends ModifierRecipe
implements IMultiRecipe<IDisplayModifierRecipe> {
    protected static final String KEY_MIN_LEVEL = TConstruct.makeTranslationKey("recipe", "modifier.min_level");
    private final List<LevelEntry> levels;
    private List<IDisplayModifierRecipe> displayRecipes = null;

    protected MultilevelModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierMatch requirements, String requirementsError, ModifierId result, boolean allowCrystal, List<LevelEntry> levels) {
        super(id, inputs, toolRequirement, maxToolSize, requirements, requirementsError, new ModifierEntry(result, 1), levels.get(0).maxLevel() + 1, levels.get(0).slots(), allowCrystal);
        this.levels = levels;
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = inv.getTinkerable();
        ValidatedResult requirements = this.validateRequirements(tool);
        if (requirements.hasError()) {
            return requirements;
        }
        int newLevel = tool.getModifierLevel(this.result.getModifier()) + 1;
        LevelEntry levelEntry = null;
        for (LevelEntry check : this.levels) {
            if (!check.matches(newLevel)) continue;
            levelEntry = check;
            break;
        }
        if (levelEntry == null) {
            if (newLevel < this.levels.get(0).minLevel()) {
                return ValidatedResult.failure(KEY_MIN_LEVEL, this.result.getModifier().getDisplayName(), this.levels.get(0).minLevel() - 1);
            }
            return ValidatedResult.failure(KEY_MAX_LEVEL, this.result.getModifier().getDisplayName(), this.levels.get(this.levels.size() - 1).maxLevel());
        }
        SlotType.SlotCount slots = levelEntry.slots();
        requirements = MultilevelModifierRecipe.checkSlots(tool, slots);
        if (requirements.hasError()) {
            return requirements;
        }
        tool = tool.copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (slots != null) {
            persistentData.addSlots(slots.getType(), -slots.getCount());
        }
        tool.addModifier(this.result.getId(), this.result.getLevel());
        ValidatedResult toolValidation = tool.validate();
        if (toolValidation.hasError()) {
            return toolValidation;
        }
        return ValidatedResult.success(tool.createStack(Math.min(inv.getTinkerableSize(), this.shrinkToolSlotBy())));
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.multilevelModifierSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes() {
        if (this.inputs.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.displayRecipes == null) {
            List<ItemStack> toolWithoutModifier = this.getToolWithoutModifier();
            List<ItemStack> toolWithModifier = this.getToolWithModifier();
            String requirementsError = this.getRequirementsError();
            this.displayRecipes = Streams.concat((Stream[])new Stream[]{Stream.of(this), this.levels.stream().skip(1L).map(levelEntry -> new DisplayModifierRecipe(this.inputs, toolWithoutModifier, toolWithModifier, requirementsError + ".level_" + levelEntry.minLevel, this.result, levelEntry.maxLevel, levelEntry.slots))}).toList();
        }
        return this.displayRecipes;
    }

    record LevelEntry(@Nullable SlotType.SlotCount slots, int minLevel, int maxLevel) {
        public boolean matches(int level) {
            return this.minLevel <= level && level <= this.maxLevel;
        }

        public static LevelEntry parse(JsonObject json) {
            int min;
            int max;
            if (json.has("level")) {
                min = max = GsonHelper.m_13927_((JsonObject)json, (String)"level");
            } else {
                min = GsonHelper.m_13824_((JsonObject)json, (String)"min_level", (int)1);
                if (min > (max = GsonHelper.m_13824_((JsonObject)json, (String)"max_level", (int)Short.MAX_VALUE))) {
                    throw new JsonSyntaxException("min_level must be less than or equal to max_level");
                }
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"slots"));
            }
            return new LevelEntry(slots, min, max);
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            if (this.slots != null) {
                JsonObject slotJson = new JsonObject();
                slotJson.addProperty(this.slots.getType().getName(), (Number)this.slots.getCount());
                json.add("slots", (JsonElement)slotJson);
            }
            if (this.minLevel == this.maxLevel) {
                json.addProperty("level", (Number)this.minLevel);
            } else {
                json.addProperty("min_level", (Number)this.minLevel);
                if (this.maxLevel < Short.MAX_VALUE) {
                    json.addProperty("max_level", (Number)this.maxLevel);
                }
            }
            return json;
        }

        public static LevelEntry read(FriendlyByteBuf buffer) {
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            int min = buffer.m_130242_();
            int max = buffer.m_130242_();
            return new LevelEntry(slots, min, max);
        }

        public void write(FriendlyByteBuf buffer) {
            SlotType.SlotCount.write(this.slots, buffer);
            buffer.m_130130_(this.minLevel);
            buffer.m_130130_(this.maxLevel);
        }
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MultilevelModifierRecipe> {
        public MultilevelModifierRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient toolRequirement = Ingredient.m_43917_((JsonElement)json.get("tools"));
            int maxToolSize = GsonHelper.m_13824_((JsonObject)json, (String)"max_tool_size", (int)16);
            ModifierId result = new ModifierId(JsonHelper.getResourceLocation((JsonObject)json, (String)"result"));
            List levels = JsonHelper.parseList((JsonObject)json, (String)"levels", LevelEntry::parse);
            List ingredients = Collections.emptyList();
            if (json.has("inputs")) {
                ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            }
            boolean allowCrystal = GsonHelper.m_13855_((JsonObject)json, (String)"allow_crystal", (boolean)true);
            if (ingredients.isEmpty() && !allowCrystal) {
                throw new JsonSyntaxException("Must either have inputs or allow crystal");
            }
            ModifierMatch requirements = ModifierMatch.ALWAYS;
            String requirementsError = "";
            if (json.has("requirements")) {
                JsonObject reqJson = GsonHelper.m_13930_((JsonObject)json, (String)"requirements");
                requirements = ModifierMatch.deserialize(reqJson);
                requirementsError = GsonHelper.m_13906_((JsonObject)reqJson, (String)"error");
            } else if (!ingredients.isEmpty()) {
                requirementsError = GsonHelper.m_13906_((JsonObject)json, (String)"level_error");
            }
            return new MultilevelModifierRecipe(id, (List<SizedIngredient>)ingredients, toolRequirement, maxToolSize, requirements, requirementsError, result, allowCrystal, levels);
        }

        @Nullable
        protected MultilevelModifierRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient toolRequirement = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int maxToolSize = buffer.m_130242_();
            ModifierMatch requirements = ModifierMatch.read(buffer);
            String requirementsError = buffer.m_130136_(Short.MAX_VALUE);
            ModifierId result = new ModifierId(buffer.m_130281_());
            int size = buffer.m_130242_();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                inputs.add((Object)SizedIngredient.read((FriendlyByteBuf)buffer));
            }
            boolean allowCrystal = buffer.readBoolean();
            size = buffer.m_130242_();
            ImmutableList.Builder levels = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                levels.add((Object)LevelEntry.read(buffer));
            }
            return new MultilevelModifierRecipe(id, (List<SizedIngredient>)inputs.build(), toolRequirement, maxToolSize, requirements, requirementsError, result, allowCrystal, (List<LevelEntry>)levels.build());
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, MultilevelModifierRecipe recipe) {
            recipe.toolRequirement.m_43923_(buffer);
            buffer.m_130130_(recipe.maxToolSize);
            recipe.requirements.write(buffer);
            buffer.m_130070_(recipe.requirementsError);
            buffer.m_130085_((ResourceLocation)recipe.result.getId());
            buffer.m_130130_(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            buffer.writeBoolean(recipe.allowCrystal);
            buffer.m_130130_(recipe.levels.size());
            for (LevelEntry level : recipe.levels) {
                level.write(buffer);
            }
        }
    }
}

