/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.BasicModifier;
import slimeknights.tconstruct.library.modifiers.modules.ModifierHookProvider;

public class ModifierHookMap {
    public static final ModifierHookMap EMPTY = new ModifierHookMap(Collections.emptyMap());
    private final Map<ModifierHook<?>, Object> modules;

    public boolean hasHook(ModifierHook<?> hook) {
        return this.modules.containsKey(hook);
    }

    @Nullable
    public <T> T getOrNull(ModifierHook<T> hook) {
        return (T)this.modules.get(hook);
    }

    public <T> T getOrDefault(ModifierHook<T> hook) {
        T object = this.getOrNull(hook);
        if (object != null) {
            return object;
        }
        return hook.getDefaultInstance();
    }

    public Map<ModifierHook<?>, Object> getAllModules() {
        return this.modules;
    }

    public ModifierHookMap(Map<ModifierHook<?>, Object> modules) {
        this.modules = modules;
    }

    public static class Builder {
        private final LinkedHashMultimap<ModifierHook<?>, Object> modules = LinkedHashMultimap.create();

        public Builder addHookChecked(Object object, ModifierHook<?> hook) {
            if (!hook.isValid(object)) {
                throw new IllegalArgumentException("Object " + object + " is invalid for hook " + hook);
            }
            this.modules.put(hook, object);
            return this;
        }

        public Builder addModule(ModifierHookProvider module) {
            for (ModifierHook<?> hook : module.getDefaultHooks()) {
                this.addHookChecked(module, hook);
            }
            return this;
        }

        public <H, T extends H> Builder addHook(T object, ModifierHook<H> hook) {
            this.modules.put(hook, object);
            return this;
        }

        public <T> Builder addHook(T object, ModifierHook<? super T> hook1, ModifierHook<? super T> hook2) {
            this.addHook(object, (ModifierHook)hook1);
            this.addHook(object, (ModifierHook)hook2);
            return this;
        }

        public <T> Builder addHook(T object, ModifierHook<? super T> hook1, ModifierHook<? super T> hook2, ModifierHook<? super T> hook3) {
            this.addHook(object, (ModifierHook)hook1);
            this.addHook(object, (ModifierHook)hook2);
            this.addHook(object, (ModifierHook)hook3);
            return this;
        }

        @SafeVarargs
        public final <T> Builder addHook(T object, ModifierHook<? super T> ... hooks) {
            for (ModifierHook<? super T> hook : hooks) {
                this.addHook(object, (ModifierHook)hook);
            }
            return this;
        }

        private static <T> void insert(ImmutableMap.Builder<ModifierHook<?>, Object> builder, ModifierHook<T> hook, Collection<Object> objects) {
            if (objects.size() == 1) {
                builder.put(hook, objects.iterator().next());
            } else if (!objects.isEmpty()) {
                builder.put(hook, hook.merge(objects));
            }
        }

        public ModifierHookMap build() {
            if (this.modules.isEmpty()) {
                return EMPTY;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.modules.asMap().entrySet()) {
                Builder.insert(builder, (ModifierHook)entry.getKey(), (Collection)entry.getValue());
            }
            return new ModifierHookMap((Map<ModifierHook<?>, Object>)builder.build());
        }

        public BasicModifier.Builder modifier() {
            return BasicModifier.Builder.builder(this.build());
        }
    }
}

