/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.spilling.effects;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record RestoreHungerSpillingEffect(int hunger, float saturation, @Nullable ItemOutput representative) implements ISpillingEffect
{
    public static final ResourceLocation ID = TConstruct.getResource("restore_hunger");
    public static final JsonDeserializer<RestoreHungerSpillingEffect> LOADER = (element, type, context) -> {
        JsonObject json = element.getAsJsonObject();
        int hunger = GsonHelper.m_13927_((JsonObject)json, (String)"hunger");
        float saturation = GsonHelper.m_13915_((JsonObject)json, (String)"saturation");
        ItemOutput representative = null;
        if (json.has("representative_item")) {
            representative = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"representative_item"));
        }
        return new RestoreHungerSpillingEffect(hunger, saturation, representative);
    };

    public RestoreHungerSpillingEffect(int hunger, float saturation) {
        this(hunger, saturation, null);
    }

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Player player;
        LivingEntity target = context.getLivingTarget();
        if (target instanceof Player && (player = (Player)target).m_36391_(false)) {
            int finalHunger = (int)((float)this.hunger * scale);
            float finalSaturation = this.saturation * scale;
            player.m_36324_().m_38707_(finalHunger, finalSaturation);
            if (this.representative != null) {
                ModifierUtil.foodConsumer.onConsume(player, this.representative.get(), finalHunger, finalSaturation);
            }
        }
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = JsonUtils.withType(ID);
        json.addProperty("hunger", (Number)this.hunger);
        json.addProperty("saturation", (Number)Float.valueOf(this.saturation));
        if (this.representative != null) {
            json.add("representative_item", this.representative.serialize());
        }
        return json;
    }
}

