/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.fluid;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.fluid.TankCapacityModule;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TankModule
extends TankCapacityModule
implements ToolFluidCapability.FluidModifierHook,
TooltipModifierHook {
    private static final String FILLED_KEY = TConstruct.makeTranslationKey("modifier", "tank.filled");
    private static final String CAPACITY_KEY = TConstruct.makeTranslationKey("modifier", "tank.capacity");
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA, ToolFluidCapability.HOOK, TinkerHooks.TOOLTIP);
    public static final ResourceLocation DEFAULT_OWNER_KEY = TConstruct.getResource("tank_owner");
    public static final ResourceLocation DEFAULT_FLUID_KEY = TConstruct.getResource("tank_fluid");
    public static final BiFunction<CompoundTag, String, FluidStack> PARSE_FLUID = (nbt, key) -> FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_(key));
    private final ResourceLocation ownerKey;
    private final ResourceLocation fluidKey;
    public static final GenericLoaderRegistry.IGenericLoader<TankModule> LOADER = new GenericLoaderRegistry.IGenericLoader<TankModule>(){

        public TankModule deserialize(JsonObject json) {
            int capacity = GsonHelper.m_13927_((JsonObject)json, (String)"capacity");
            boolean scaleCapacity = GsonHelper.m_13912_((JsonObject)json, (String)"scale_capacity");
            ResourceLocation capacityKey = JsonHelper.getResourceLocation((JsonObject)json, (String)"capacity_key", (ResourceLocation)TankCapacityModule.DEFAULT_CAPACITY_KEY);
            ResourceLocation fluidKey = JsonHelper.getResourceLocation((JsonObject)json, (String)"fluid_key", (ResourceLocation)DEFAULT_FLUID_KEY);
            ResourceLocation ownerKey = JsonHelper.getResourceLocation((JsonObject)json, (String)"owner_key", (ResourceLocation)DEFAULT_OWNER_KEY);
            return new TankModule(capacityKey, capacity, scaleCapacity, fluidKey, ownerKey);
        }

        public void serialize(TankModule object, JsonObject json) {
            json.addProperty("capacity", (Number)object.getCapacity());
            json.addProperty("scale_capacity", Boolean.valueOf(object.isScaleCapacity()));
            ResourceLocation capacityKey = object.getCapacityKey();
            if (capacityKey != TankCapacityModule.DEFAULT_CAPACITY_KEY) {
                json.addProperty("capacity_key", capacityKey.toString());
            }
            if (object.fluidKey != DEFAULT_FLUID_KEY) {
                json.addProperty("fluid_key", object.fluidKey.toString());
            }
            if (object.ownerKey != DEFAULT_OWNER_KEY) {
                json.addProperty("owner_key", object.ownerKey.toString());
            }
        }

        public TankModule fromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation capacityKey = buffer.m_130281_();
            int capacity = buffer.m_130242_();
            boolean scaleCapacity = buffer.readBoolean();
            ResourceLocation fluidKey = buffer.m_130281_();
            ResourceLocation ownerKey = buffer.m_130281_();
            return new TankModule(capacityKey, capacity, scaleCapacity, fluidKey, ownerKey);
        }

        public void toNetwork(TankModule object, FriendlyByteBuf buffer) {
            buffer.m_130085_(object.getCapacityKey());
            buffer.m_130130_(object.getCapacity());
            buffer.writeBoolean(object.isScaleCapacity());
            buffer.m_130085_(object.fluidKey);
            buffer.m_130085_(object.ownerKey);
        }
    };

    public TankModule(ResourceLocation capacityKey, int capacity, boolean scaleCapacity, ResourceLocation fluidKey, ResourceLocation ownerKey) {
        super(capacityKey, capacity, scaleCapacity);
        this.ownerKey = ownerKey;
        this.fluidKey = fluidKey;
    }

    public TankModule(int capacity, boolean scaleCapacity) {
        this(DEFAULT_CAPACITY_KEY, capacity, scaleCapacity, DEFAULT_FLUID_KEY, DEFAULT_OWNER_KEY);
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.isOwner(tool, modifier.getId())) {
            FluidStack current = this.getFluid(tool);
            if (!current.isEmpty()) {
                tooltip.add((Component)new TranslatableComponent(FILLED_KEY, new Object[]{current.getAmount(), current.getDisplayName()}));
            }
            tooltip.add((Component)new TranslatableComponent(CAPACITY_KEY, new Object[]{this.getCapacity(tool)}));
        }
    }

    public boolean isOwner(IToolContext tool, ModifierId modifier) {
        ResourceLocation key = this.getOwnerKey();
        if (key == null) {
            return true;
        }
        return modifier.toString().equals(tool.getVolatileData().getString(key));
    }

    @Override
    public int getTanks(IToolContext tool, Modifier modifier) {
        return this.isOwner(tool, modifier.getId()) ? 1 : 0;
    }

    @Override
    public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.isOwner(tool, modifier.getId()) ? this.getCapacity(tool) : 0;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        super.addVolatileData(context, modifier, volatileData);
        ResourceLocation ownerKey = this.getOwnerKey();
        if (!volatileData.contains(ownerKey, 8)) {
            volatileData.putString(ownerKey, modifier.getId().toString());
        }
        ToolFluidCapability.addTanks(context, modifier.getModifier(), volatileData, this);
    }

    public FluidStack getFluid(IToolStackView tool) {
        return tool.getPersistentData().get(this.getFluidKey(), PARSE_FLUID);
    }

    public FluidStack setFluid(IToolStackView tool, FluidStack fluid) {
        if (fluid.isEmpty()) {
            tool.getPersistentData().remove(this.getFluidKey());
            return fluid;
        }
        int capacity = this.getCapacity(tool);
        if (fluid.getAmount() > capacity) {
            fluid.setAmount(capacity);
        }
        tool.getPersistentData().put(this.getFluidKey(), (Tag)fluid.writeToNBT(new CompoundTag()));
        return fluid;
    }

    @Override
    public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.isOwner(tool, modifier.getId()) ? this.getFluid(tool) : FluidStack.EMPTY;
    }

    @Override
    public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isEmpty() && this.isOwner(tool, modifier.getId())) {
            FluidStack current = this.getFluid(tool);
            int capacity = this.getCapacity(tool);
            if (current.isEmpty()) {
                if (action.execute()) {
                    this.setFluid(tool, resource);
                }
                return Math.min(resource.getAmount(), capacity);
            }
            if (current.getAmount() < capacity && current.isFluidEqual(resource)) {
                int filled = Math.min(resource.getAmount(), capacity - current.getAmount());
                if (filled > 0 && action.execute()) {
                    current.grow(filled);
                    this.setFluid(tool, current);
                }
                return filled;
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack current;
        if (!resource.isEmpty() && this.isOwner(tool, modifier.getId()) && !(current = this.getFluid(tool)).isEmpty() && current.isFluidEqual(resource)) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), resource.getAmount()));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack current;
        if (maxDrain > 0 && this.isOwner(tool, modifier.getId()) && !(current = this.getFluid(tool)).isEmpty()) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), maxDrain));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public ResourceLocation getOwnerKey() {
        return this.ownerKey;
    }

    public ResourceLocation getFluidKey() {
        return this.fluidKey;
    }
}

