/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.fluid;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TankCapacityModule
implements ModifierModule,
VolatileDataModifierHook {
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA);
    public static final ResourceLocation DEFAULT_CAPACITY_KEY = TConstruct.getResource("tank_capacity");
    private final ResourceLocation capacityKey;
    private final int capacity;
    private final boolean scaleCapacity;
    public static final GenericLoaderRegistry.IGenericLoader<TankCapacityModule> LOADER = new GenericLoaderRegistry.IGenericLoader<TankCapacityModule>(){

        public TankCapacityModule deserialize(JsonObject json) {
            int capacity = GsonHelper.m_13927_((JsonObject)json, (String)"capacity");
            boolean scaleCapacity = GsonHelper.m_13912_((JsonObject)json, (String)"scale_capacity");
            ResourceLocation capacityKey = JsonHelper.getResourceLocation((JsonObject)json, (String)"capacity_key", (ResourceLocation)DEFAULT_CAPACITY_KEY);
            return new TankCapacityModule(capacityKey, capacity, scaleCapacity);
        }

        public void serialize(TankCapacityModule object, JsonObject json) {
            json.addProperty("capacity", (Number)object.capacity);
            json.addProperty("scale_capacity", Boolean.valueOf(object.scaleCapacity));
            if (object.capacityKey != DEFAULT_CAPACITY_KEY) {
                json.addProperty("capacity_key", object.capacityKey.toString());
            }
        }

        public TankCapacityModule fromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation capacityKey = buffer.m_130281_();
            int capacity = buffer.m_130242_();
            boolean scaleCapacity = buffer.readBoolean();
            return new TankCapacityModule(capacityKey, capacity, scaleCapacity);
        }

        public void toNetwork(TankCapacityModule object, FriendlyByteBuf buffer) {
            buffer.m_130085_(object.capacityKey);
            buffer.m_130130_(object.capacity);
            buffer.writeBoolean(object.scaleCapacity);
        }
    };

    public TankCapacityModule(int capacity, boolean scaleCapacity) {
        this(DEFAULT_CAPACITY_KEY, capacity, scaleCapacity);
    }

    public int getCapacity(IToolStackView tool) {
        return tool.getVolatileData().getInt(this.getCapacityKey());
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        ResourceLocation key = this.getCapacityKey();
        volatileData.putInt(key, this.capacity * (this.scaleCapacity ? modifier.getLevel() : 1) + volatileData.getInt(key));
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public ResourceLocation getCapacityKey() {
        return this.capacityKey;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isScaleCapacity() {
        return this.scaleCapacity;
    }

    public TankCapacityModule(ResourceLocation capacityKey, int capacity, boolean scaleCapacity) {
        this.capacityKey = capacityKey;
        this.capacity = capacity;
        this.scaleCapacity = scaleCapacity;
    }
}

