/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.AttributeModuleBuilder;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record MeleeAttributeModule(String unique, Attribute attribute, UUID uuid, AttributeModifier.Operation operation, LevelingValue amount, ModifierModuleCondition condition) implements ModifierModule,
MeleeHitModifierHook
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.MELEE_HIT);
    public static final GenericLoaderRegistry.IGenericLoader<MeleeAttributeModule> LOADER = new GenericLoaderRegistry.IGenericLoader<MeleeAttributeModule>(){

        public MeleeAttributeModule deserialize(JsonObject json) {
            return new MeleeAttributeModule(GsonHelper.m_13906_((JsonObject)json, (String)"unique"), (Attribute)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (JsonObject)json, (String)"attribute"), (AttributeModifier.Operation)JsonHelper.getAsEnum((JsonObject)json, (String)"operation", AttributeModifier.Operation.class), LevelingValue.deserialize(json), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(MeleeAttributeModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.addProperty("unique", object.unique);
            json.addProperty("attribute", Objects.requireNonNull(object.attribute.getRegistryName()).toString());
            json.addProperty("operation", object.operation.name().toLowerCase(Locale.ROOT));
            object.amount.serialize(json);
        }

        public MeleeAttributeModule fromNetwork(FriendlyByteBuf buffer) {
            return new MeleeAttributeModule(buffer.m_130136_(Short.MAX_VALUE), (Attribute)buffer.readRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES), (AttributeModifier.Operation)buffer.m_130066_(AttributeModifier.Operation.class), LevelingValue.fromNetwork(buffer), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(MeleeAttributeModule object, FriendlyByteBuf buffer) {
            buffer.m_130070_(object.unique);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES, (IForgeRegistryEntry)object.attribute);
            buffer.m_130068_((Enum)object.operation);
            object.amount.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    public MeleeAttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, LevelingValue amount, ModifierModuleCondition condition) {
        this(unique, attribute, UUID.nameUUIDFromBytes(unique.getBytes()), operation, amount, condition);
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        AttributeInstance instance;
        LivingEntity target;
        if (this.condition.matches(tool, modifier) && (target = context.getLivingTarget()) != null && (instance = target.m_21051_(this.attribute)) != null) {
            instance.m_22118_(new AttributeModifier(this.uuid, this.unique, (double)this.amount.compute(tool, modifier), this.operation));
        }
        return knockback;
    }

    private void removeAttribute(@Nullable LivingEntity target) {
        AttributeInstance instance;
        if (target != null && (instance = target.m_21051_(this.attribute)) != null) {
            instance.m_22120_(this.uuid);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.removeAttribute(context.getLivingTarget());
    }

    @Override
    public void failedMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageAttempted) {
        this.removeAttribute(context.getLivingTarget());
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(Attribute attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute, operation);
    }

    public static class Builder
    extends AttributeModuleBuilder<Builder, MeleeAttributeModule> {
        private Builder(Attribute attribute, AttributeModifier.Operation operation) {
            super(attribute, operation);
        }

        @Override
        public MeleeAttributeModule amount(float flat, float eachLevel) {
            if (this.unique == null) {
                throw new IllegalStateException("Must set unique for attributes");
            }
            return new MeleeAttributeModule(this.unique, this.attribute, this.operation, new LevelingValue(flat, eachLevel), this.condition);
        }
    }
}

