/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.util.ModuleWithKey;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public record SwappableSlotModule(@Nullable ResourceLocation key, int slotCount) implements VolatileDataModifierHook,
DisplayNameModifierHook,
ModifierRemovalHook,
ModifierModule,
ModuleWithKey
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA, TinkerHooks.DISPLAY_NAME, TinkerHooks.REMOVE);
    private static final String FORMAT = TConstruct.makeTranslationKey("modifier", "extra_modifier.type_format");
    public static final GenericLoaderRegistry.IGenericLoader<SwappableSlotModule> LOADER = new GenericLoaderRegistry.IGenericLoader<SwappableSlotModule>(){

        public SwappableSlotModule deserialize(JsonObject json) {
            ResourceLocation key = ModuleWithKey.parseKey(json);
            int slotCount = GsonHelper.m_13927_((JsonObject)json, (String)"slots");
            return new SwappableSlotModule(key, slotCount);
        }

        public void serialize(SwappableSlotModule object, JsonObject json) {
            if (object.key != null) {
                json.addProperty("key", object.key.toString());
            }
            json.addProperty("slots", (Number)object.slotCount);
        }

        public SwappableSlotModule fromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation key = ModuleWithKey.fromNetwork(buffer);
            int slotCount = buffer.readInt();
            return new SwappableSlotModule(key, slotCount);
        }

        public void toNetwork(SwappableSlotModule object, FriendlyByteBuf buffer) {
            ModuleWithKey.toNetwork(object.key, buffer);
            buffer.writeInt(object.slotCount);
        }
    };

    public SwappableSlotModule(int slotCount) {
        this(null, slotCount);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, Modifier modifier, int level, Component name) {
        SlotType type;
        String slotName = tool.getPersistentData().getString(this.getKey(modifier));
        if (!slotName.isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            return new TranslatableComponent(FORMAT, new Object[]{name.m_6879_(), type.getDisplayName()}).m_130938_(style -> style.m_131148_(type.getColor()));
        }
        return name;
    }

    @Override
    public Integer getPriority() {
        return 50;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        SlotType type;
        String slotName = context.getPersistentData().getString(this.getKey(modifier.getModifier()));
        if (!slotName.isEmpty() && (type = SlotType.getIfPresent(slotName)) != null) {
            volatileData.addSlots(type, this.slotCount);
        }
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(modifier.getId());
        return null;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public record BonusSlot(@Nullable ResourceLocation key, SlotType match, SlotType bonus, int slotCount) implements VolatileDataModifierHook,
    ModifierModule,
    ModuleWithKey
    {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA);
        public static final GenericLoaderRegistry.IGenericLoader<BonusSlot> LOADER = new GenericLoaderRegistry.IGenericLoader<BonusSlot>(){

            public BonusSlot deserialize(JsonObject json) {
                ResourceLocation key = ModuleWithKey.parseKey(json);
                SlotType match = SlotType.getOrCreate(GsonHelper.m_13906_((JsonObject)json, (String)"match"));
                SlotType bonus = SlotType.getOrCreate(GsonHelper.m_13906_((JsonObject)json, (String)"bonus"));
                int slotCount = GsonHelper.m_13927_((JsonObject)json, (String)"slots");
                return new BonusSlot(key, match, bonus, slotCount);
            }

            public void serialize(BonusSlot object, JsonObject json) {
                if (object.key != null) {
                    json.addProperty("key", object.key.toString());
                }
                json.addProperty("match", object.match.getName());
                json.addProperty("bonus", object.bonus.getName());
                json.addProperty("slots", (Number)object.slotCount);
            }

            public BonusSlot fromNetwork(FriendlyByteBuf buffer) {
                ResourceLocation key = ModuleWithKey.fromNetwork(buffer);
                SlotType match = SlotType.read(buffer);
                SlotType bonus = SlotType.read(buffer);
                int slots = buffer.readInt();
                return new BonusSlot(key, match, bonus, slots);
            }

            public void toNetwork(BonusSlot object, FriendlyByteBuf buffer) {
                ModuleWithKey.toNetwork(object.key, buffer);
                object.match.write(buffer);
                object.bonus.write(buffer);
                buffer.writeInt(object.slotCount);
            }
        };

        public BonusSlot(SlotType match, SlotType penalty, int slotCount) {
            this(null, match, penalty, slotCount);
        }

        @Override
        public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
            String slotName = context.getPersistentData().getString(this.getKey(modifier.getModifier()));
            if (!slotName.isEmpty() && this.match.getName().equals(slotName)) {
                volatileData.addSlots(this.bonus, this.slotCount);
            }
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }
}

