/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.util.ModifierStatBoost;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record StatBoostModule(INumericToolStat<?> stat, ModifierStatBoost.BoostType operation, LevelingValue amount, ModifierModuleCondition condition) implements ToolStatsModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.TOOL_STATS);
    public static GenericLoaderRegistry.IGenericLoader<StatBoostModule> LOADER = new GenericLoaderRegistry.IGenericLoader<StatBoostModule>(){

        public StatBoostModule deserialize(JsonObject json) {
            INumericToolStat<?> stat = ToolStats.numericFromJson(GsonHelper.m_13906_((JsonObject)json, (String)"stat"));
            ModifierStatBoost.BoostType boostType = (ModifierStatBoost.BoostType)JsonHelper.getAsEnum((JsonObject)json, (String)"operation", ModifierStatBoost.BoostType.class);
            LevelingValue amount = LevelingValue.deserialize(json);
            ModifierModuleCondition condition = ModifierModuleCondition.deserializeFrom(json);
            return new StatBoostModule(stat, boostType, amount, condition);
        }

        public void serialize(StatBoostModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.addProperty("stat", object.stat.getName().toString());
            json.addProperty("operation", object.operation.getName());
            object.amount.serialize(json);
        }

        public StatBoostModule fromNetwork(FriendlyByteBuf buffer) {
            INumericToolStat<?> stat = ToolStats.numericFromNetwork(buffer);
            ModifierStatBoost.BoostType operation = (ModifierStatBoost.BoostType)buffer.m_130066_(ModifierStatBoost.BoostType.class);
            LevelingValue amount = LevelingValue.fromNetwork(buffer);
            ModifierModuleCondition condition = ModifierModuleCondition.fromNetwork(buffer);
            return new StatBoostModule(stat, operation, amount, condition);
        }

        public void toNetwork(StatBoostModule object, FriendlyByteBuf buffer) {
            buffer.m_130070_(object.stat.getName().toString());
            buffer.m_130068_((Enum)object.operation);
            object.amount.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    public void addToolStats(ToolRebuildContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        if (this.condition.matches(context, modifier)) {
            this.operation.apply(builder, this.stat, this.amount.compute(context, modifier), 1.0f);
        }
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder add(INumericToolStat<?> stat) {
        return new Builder(stat, ModifierStatBoost.BoostType.ADD);
    }

    public static Builder multiplyBase(INumericToolStat<?> stat) {
        return new Builder(stat, ModifierStatBoost.BoostType.MULTIPLY_BASE);
    }

    public static Builder multiplyConditional(INumericToolStat<?> stat) {
        return new Builder(stat, ModifierStatBoost.BoostType.MULTIPLY_CONDITIONAL);
    }

    public static Builder multiplyAll(INumericToolStat<?> stat) {
        return new Builder(stat, ModifierStatBoost.BoostType.MULTIPLY_ALL);
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder>
    implements LevelingValue.Builder<StatBoostModule> {
        private final INumericToolStat<?> stat;
        private final ModifierStatBoost.BoostType operation;

        @Override
        public StatBoostModule amount(float flat, float eachLevel) {
            return new StatBoostModule(this.stat, this.operation, new LevelingValue(flat, eachLevel), this.condition);
        }

        private Builder(INumericToolStat<?> stat, ModifierStatBoost.BoostType operation) {
            this.stat = stat;
            this.operation = operation;
        }
    }
}

