/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;

public record ModifierTraitModule(ModifierEntry modifier, boolean fixedLevel) implements ModifierTraitHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.MODIFIER_TRAITS);
    public static final GenericLoaderRegistry.IGenericLoader<ModifierTraitModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ModifierTraitModule>(){

        public ModifierTraitModule deserialize(JsonObject json) {
            ModifierEntry modifier = ModifierEntry.fromJson(json);
            boolean fixedLevel = GsonHelper.m_13912_((JsonObject)json, (String)"fixed_level");
            return new ModifierTraitModule(modifier, fixedLevel);
        }

        public void serialize(ModifierTraitModule object, JsonObject json) {
            object.modifier.toJson(json);
            json.addProperty("fixed_level", Boolean.valueOf(object.fixedLevel));
        }

        public ModifierTraitModule fromNetwork(FriendlyByteBuf buffer) {
            ModifierEntry modifier = ModifierEntry.read(buffer);
            boolean fixedLevel = buffer.readBoolean();
            return new ModifierTraitModule(modifier, fixedLevel);
        }

        public void toNetwork(ModifierTraitModule object, FriendlyByteBuf buffer) {
            object.modifier.write(buffer);
            buffer.writeBoolean(object.fixedLevel);
        }
    };

    public ModifierTraitModule(ModifierId id, int level, boolean fixedLevel) {
        this(new ModifierEntry(id, level), fixedLevel);
    }

    @Override
    public void addTraits(ToolRebuildContext context, ModifierEntry self, ModifierTraitHook.TraitBuilder builder, boolean firstEncounter) {
        if (this.fixedLevel) {
            if (firstEncounter) {
                builder.addEntry(this.modifier);
            }
        } else {
            builder.addEntry(this.modifier.withLevel(this.modifier.getLevel() * self.getLevel()));
        }
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierTraitModule> getLoader() {
        return LOADER;
    }
}

