/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record ModifierSlotModule(SlotType type, int count, ModifierModuleCondition condition) implements VolatileDataModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA);
    public static final GenericLoaderRegistry.IGenericLoader<ModifierSlotModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ModifierSlotModule>(){

        public ModifierSlotModule deserialize(JsonObject json) {
            String slotName = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            if (!SlotType.isValidName(slotName)) {
                throw new JsonSyntaxException("Invalid slot type name '" + slotName + "'");
            }
            int count = JsonUtils.getIntMin(json, "count", 1);
            return new ModifierSlotModule(SlotType.getOrCreate(slotName), count, ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(ModifierSlotModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.addProperty("name", object.type.getName());
            json.addProperty("count", (Number)object.count);
        }

        public ModifierSlotModule fromNetwork(FriendlyByteBuf buffer) {
            SlotType type = SlotType.read(buffer);
            int slotCount = buffer.m_130242_();
            return new ModifierSlotModule(type, slotCount, ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(ModifierSlotModule object, FriendlyByteBuf buffer) {
            object.type.write(buffer);
            buffer.m_130130_(object.count);
            object.condition.toNetwork(buffer);
        }
    };

    public ModifierSlotModule(SlotType type, int count) {
        this(type, count, ModifierModuleCondition.ANY);
    }

    public ModifierSlotModule(SlotType type) {
        this(type, 1);
    }

    @Override
    public Integer getPriority() {
        return 50;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        if (this.condition.matches(context, modifier)) {
            volatileData.addSlots(this.type, this.count * modifier.getLevel());
        }
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }
}

