/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.ToolAction;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ToolActionsModule(Set<ToolAction> actions, ModifierModuleCondition condition) implements ToolActionModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.TOOL_ACTION);
    public static final GenericLoaderRegistry.IGenericLoader<ToolActionsModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ToolActionsModule>(){

        public ToolActionsModule deserialize(JsonObject json) {
            return new ToolActionsModule((Set<ToolAction>)ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"tool_actions", (element, name) -> ToolAction.get((String)GsonHelper.m_13805_((JsonElement)element, (String)name)))), ModifierModuleCondition.deserializeFrom(json));
        }

        public ToolActionsModule fromNetwork(FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ImmutableSet.Builder actions = ImmutableSet.builder();
            for (int i = 0; i < size; ++i) {
                actions.add((Object)ToolAction.get((String)buffer.m_130136_(Short.MAX_VALUE)));
            }
            return new ToolActionsModule((Set<ToolAction>)actions.build(), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void serialize(ToolActionsModule object, JsonObject json) {
            object.condition.serializeInto(json);
            JsonArray actions = new JsonArray();
            for (ToolAction action : object.actions) {
                actions.add(action.name());
            }
            json.add("actions", (JsonElement)actions);
        }

        public void toNetwork(ToolActionsModule object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.actions.size());
            for (ToolAction action : object.actions) {
                buffer.m_130070_(action.name());
            }
            object.condition.toNetwork(buffer);
        }
    };

    public ToolActionsModule(ToolAction ... actions) {
        this((Set<ToolAction>)ImmutableSet.copyOf((Object[])actions), ModifierModuleCondition.ANY);
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return this.condition.matches(tool, modifier) && this.actions.contains(toolAction);
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }
}

