/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.armor.ArmorWalkRadiusModule;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.MutableUseOnContext;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record ToolActionWalkerTransformModule(ToolAction action, SoundEvent sound, LevelingValue radius, ModifierModuleCondition condition) implements ModifierModule,
ArmorWalkRadiusModule<MutableUseOnContext>,
ToolActionModifierHook
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.BOOT_WALK, TinkerHooks.TOOL_ACTION);
    public static final GenericLoaderRegistry.IGenericLoader<ToolActionWalkerTransformModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ToolActionWalkerTransformModule>(){

        public ToolActionWalkerTransformModule deserialize(JsonObject json) {
            return new ToolActionWalkerTransformModule(ToolAction.get((String)GsonHelper.m_13906_((JsonObject)json, (String)"tool_action")), (SoundEvent)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (JsonObject)json, (String)"sound"), LevelingValue.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"radius")), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(ToolActionWalkerTransformModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.addProperty("tool_action", object.action.name());
            json.addProperty("sound", Objects.requireNonNull(object.sound.getRegistryName()).toString());
            json.add("radius", (JsonElement)object.radius.serialize(new JsonObject()));
        }

        public ToolActionWalkerTransformModule fromNetwork(FriendlyByteBuf buffer) {
            return new ToolActionWalkerTransformModule(ToolAction.get((String)buffer.m_130136_(Short.MAX_VALUE)), (SoundEvent)buffer.readRegistryIdUnsafe(ForgeRegistries.SOUND_EVENTS), LevelingValue.fromNetwork(buffer), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(ToolActionWalkerTransformModule object, FriendlyByteBuf buffer) {
            buffer.m_130070_(object.action.name());
            buffer.writeRegistryIdUnsafe(ForgeRegistries.SOUND_EVENTS, (IForgeRegistryEntry)object.sound);
            object.radius.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float getRadius(IToolStackView tool, ModifierEntry modifier) {
        return this.radius.compute(modifier.getLevel() + tool.getModifierLevel(TinkerModifiers.expanded.getId()));
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return this.condition.matches(tool, modifier) && toolAction == this.action;
    }

    @Override
    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (this.condition.matches(tool, modifier)) {
            ArmorWalkRadiusModule.super.onWalk(tool, modifier, living, prevPos, newPos);
        }
    }

    @Override
    public MutableUseOnContext getContext(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        Player p;
        return new MutableUseOnContext(living.m_183503_(), living instanceof Player ? (p = (Player)living) : null, InteractionHand.MAIN_HAND, living.m_6844_(EquipmentSlot.FEET), Util.createTraceResult(newPos, Direction.UP, false));
    }

    @Override
    public void walkOn(IToolStackView tool, ModifierEntry entry, LivingEntity living, Level world, BlockPos target, BlockPos.MutableBlockPos mutable, MutableUseOnContext context) {
        Material material = world.m_8055_(target).m_60767_();
        if (material.m_76336_() || material == Material.f_76300_) {
            mutable.m_122178_(target.m_123341_(), target.m_123342_() - 1, target.m_123343_());
            context.setOffsetPos((BlockPos)mutable);
            BlockState original = world.m_8055_((BlockPos)mutable);
            BlockState transformed = original.getToolModifiedState((UseOnContext)context, this.action, false);
            if (transformed != null) {
                world.m_7731_((BlockPos)mutable, transformed, 11);
                world.m_46961_(target, true);
                world.m_5594_(null, (BlockPos)mutable, this.sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlot.FEET);
            }
        }
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(ToolAction action, SoundEvent sound) {
        return new Builder(action, sound);
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder>
    implements LevelingValue.Builder<ToolActionWalkerTransformModule> {
        private final ToolAction action;
        private final SoundEvent sound;

        @Override
        public ToolActionWalkerTransformModule amount(float flat, float eachLevel) {
            return new ToolActionWalkerTransformModule(this.action, this.sound, new LevelingValue(flat, eachLevel), this.condition);
        }

        private Builder(ToolAction action, SoundEvent sound) {
            this.action = action;
            this.sound = sound;
        }
    }
}

