/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

@Deprecated
public class LootModifier
extends Modifier
implements LootingModifierHook,
HarvestEnchantmentsModifierHook {
    @Nullable
    private final Enchantment enchantment;
    private final int enchantmentLevel;
    private final int lootingLevel;
    private final ModifierLevelDisplay levelDisplay;
    public static final GenericLoaderRegistry.IGenericLoader<LootModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<LootModifier>(){

        public LootModifier deserialize(JsonObject json) {
            Enchantment enchantment = null;
            int enchantmentLevel = 0;
            if (json.has("enchantment")) {
                JsonObject enchantmentJson = GsonHelper.m_13930_((JsonObject)json, (String)"enchantment");
                enchantment = (Enchantment)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (JsonObject)enchantmentJson, (String)"name");
                enchantmentLevel = GsonHelper.m_13824_((JsonObject)enchantmentJson, (String)"level", (int)1);
            }
            int looting = GsonHelper.m_13824_((JsonObject)json, (String)"looting", (int)0);
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            return new LootModifier(enchantment, enchantmentLevel, looting, display);
        }

        public void serialize(LootModifier object, JsonObject json) {
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)object.levelDisplay));
            if (object.enchantmentLevel > 0 && object.enchantment != null) {
                JsonObject enchantment = new JsonObject();
                enchantment.addProperty("name", Objects.requireNonNull(object.enchantment.getRegistryName()).toString());
                enchantment.addProperty("level", (Number)object.enchantmentLevel);
                json.add("enchantment", (JsonElement)enchantment);
            }
            if (object.lootingLevel > 0) {
                json.addProperty("looting", (Number)object.lootingLevel);
            }
        }

        public LootModifier fromNetwork(FriendlyByteBuf buffer) {
            int enchantmentLevel = buffer.m_130242_();
            Enchantment enchantment = null;
            if (enchantmentLevel > 0) {
                enchantment = (Enchantment)buffer.readRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS);
            }
            int lootingLevel = buffer.m_130242_();
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            return new LootModifier(enchantment, enchantmentLevel, lootingLevel, display);
        }

        public void toNetwork(LootModifier object, FriendlyByteBuf buffer) {
            if (object.enchantmentLevel > 0 && object.enchantment != null) {
                buffer.m_130130_(object.enchantmentLevel);
                buffer.writeRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS, (IForgeRegistryEntry)object.enchantment);
            } else {
                buffer.m_130130_(0);
            }
            buffer.m_130130_(object.lootingLevel);
            ModifierLevelDisplay.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)object.levelDisplay, buffer);
        }
    };

    public LootModifier(Enchantment enchantment, int level, ModifierLevelDisplay levelDisplay) {
        this(enchantment, level, 0, levelDisplay);
    }

    public LootModifier(int lootingLevel, ModifierLevelDisplay levelDisplay) {
        this(null, 0, lootingLevel, levelDisplay);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.TOOL_LOOTING, TinkerHooks.LEGGINGS_LOOTING, TinkerHooks.PROJECTILE_LOOTING, TinkerHooks.TOOL_HARVEST_ENCHANTMENTS, TinkerHooks.LEGGINGS_HARVEST_ENCHANTMENTS);
    }

    @Override
    public Component getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public int getLootingValue(IToolStackView tool, ModifierEntry modifier, LivingEntity holder, Entity target, @Nullable DamageSource damageSource, int looting) {
        return looting + this.lootingLevel * modifier.getLevel();
    }

    @Override
    public void applyHarvestEnchantments(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, BiConsumer<Enchantment, Integer> consumer) {
        if (this.enchantment != null && this.enchantmentLevel > 0) {
            consumer.accept(this.enchantment, this.enchantmentLevel * modifier.getLevel());
        }
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    public LootModifier(@Nullable Enchantment enchantment, int enchantmentLevel, int lootingLevel, ModifierLevelDisplay levelDisplay) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
        this.lootingLevel = lootingLevel;
        this.levelDisplay = levelDisplay;
    }
}

