/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.build.EnchantmentModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

@Deprecated
public class EnchantmentModifier
extends Modifier {
    private final Enchantment enchantment;
    private final int enchantmentLevel;
    private final ModifierLevelDisplay levelDisplay;
    public static final GenericLoaderRegistry.IGenericLoader<EnchantmentModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<EnchantmentModifier>(){

        public EnchantmentModifier deserialize(JsonObject json) {
            JsonObject enchantmentJson = GsonHelper.m_13930_((JsonObject)json, (String)"enchantment");
            Enchantment enchantment = (Enchantment)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (JsonObject)enchantmentJson, (String)"name");
            int level = GsonHelper.m_13824_((JsonObject)enchantmentJson, (String)"level", (int)1);
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            return new EnchantmentModifier(enchantment, level, display);
        }

        public void serialize(EnchantmentModifier object, JsonObject json) {
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)object.levelDisplay));
            JsonObject enchantmentJson = new JsonObject();
            enchantmentJson.addProperty("name", Objects.requireNonNull(object.enchantment.getRegistryName()).toString());
            enchantmentJson.addProperty("level", (Number)object.enchantmentLevel);
            json.add("enchantment", (JsonElement)enchantmentJson);
        }

        public EnchantmentModifier fromNetwork(FriendlyByteBuf buffer) {
            Enchantment enchantment = (Enchantment)buffer.readRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS);
            int level = buffer.m_130242_();
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            return new EnchantmentModifier(enchantment, level, display);
        }

        public void toNetwork(EnchantmentModifier object, FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ENCHANTMENTS, (IForgeRegistryEntry)object.enchantment);
            buffer.m_130130_(object.enchantmentLevel);
            ModifierLevelDisplay.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)object.levelDisplay, buffer);
        }
    };

    @Override
    public Component getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Deprecated
    public static void addEnchantmentData(RestrictedCompoundTag tag, Enchantment enchantment, int level) {
        EnchantmentModule.setEnchantmentLevel(tag, enchantment, level);
    }

    @Deprecated
    public static void removeEnchantmentData(RestrictedCompoundTag tag, Enchantment enchantment) {
        EnchantmentModule.removeEnchantment(tag, enchantment);
    }

    @Override
    public void addRawData(IToolStackView tool, int level, RestrictedCompoundTag tag) {
        EnchantmentModifier.addEnchantmentData(tag, this.enchantment, level * this.enchantmentLevel);
    }

    @Override
    public void beforeRemoved(IToolStackView tool, RestrictedCompoundTag tag) {
        EnchantmentModifier.removeEnchantmentData(tag, this.enchantment);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    public EnchantmentModifier(Enchantment enchantment, int enchantmentLevel, ModifierLevelDisplay levelDisplay) {
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
        this.levelDisplay = levelDisplay;
    }
}

