/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public class ModifierEntry
implements Comparable<ModifierEntry> {
    public static final Serializer SERIALIZER = new Serializer();
    private final LazyModifier modifier;
    private final int level;

    public ModifierEntry(ModifierId id, int level) {
        this(new LazyModifier(id), level);
    }

    public ModifierEntry(Modifier modifier, int level) {
        this(new LazyModifier(modifier), level);
    }

    public boolean isBound() {
        return this.modifier.isBound();
    }

    public ModifierId getId() {
        return this.modifier.getId();
    }

    public Modifier getModifier() {
        return this.modifier.get();
    }

    public LazyModifier getLazyModifier() {
        return this.modifier;
    }

    public float getEffectiveLevel(IToolContext tool) {
        return this.modifier.get().getEffectiveLevel(tool, this.level);
    }

    public final <T> T getHook(ModifierHook<T> hook) {
        return this.modifier.get().getHook(hook);
    }

    public boolean matches(ModifierId id) {
        return this.modifier.getId().equals((Object)id);
    }

    public boolean matches(Modifier modifier) {
        return this.matches(modifier.getId());
    }

    public boolean matches(TagKey<Modifier> tag) {
        return this.modifier.is(tag);
    }

    @Override
    public int compareTo(ModifierEntry other) {
        int priority2;
        Modifier mod1 = this.getModifier();
        Modifier mod2 = other.getModifier();
        int priority1 = mod1.getPriority();
        if (priority1 != (priority2 = mod2.getPriority())) {
            return Integer.compare(priority2, priority1);
        }
        return mod1.getId().m_135815_().compareTo(mod2.getId().m_135815_());
    }

    public static ModifierEntry fromJson(JsonObject json) {
        return new ModifierEntry(ModifierId.getFromJson(json, "name"), GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1));
    }

    public JsonObject toJson(JsonObject json) {
        json.addProperty("name", this.getId().toString());
        json.addProperty("level", (Number)this.level);
        return json;
    }

    public JsonObject toJson() {
        return this.toJson(new JsonObject());
    }

    public static ModifierEntry read(FriendlyByteBuf buffer) {
        return new ModifierEntry(ModifierId.fromNetwork(buffer), buffer.m_130242_());
    }

    public void write(FriendlyByteBuf buffer) {
        this.getId().toNetwork(buffer);
        buffer.m_130130_(this.level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifierEntry entry = (ModifierEntry)o;
        return this.matches(entry.getId()) && this.level == entry.level;
    }

    public int hashCode() {
        return 31 * this.modifier.hashCode() + Objects.hash(this.level);
    }

    public String toString() {
        return "ModifierEntry{" + this.modifier.getId() + ",level=" + this.level + "}";
    }

    public ModifierEntry(LazyModifier modifier, int level) {
        this.modifier = modifier;
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public ModifierEntry withLevel(int level) {
        return this.level == level ? this : new ModifierEntry(this.modifier, level);
    }

    private static class Serializer
    implements JsonDeserializer<ModifierEntry>,
    JsonSerializer<ModifierEntry> {
        private Serializer() {
        }

        public ModifierEntry deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return ModifierEntry.fromJson(GsonHelper.m_13918_((JsonElement)json, (String)"modifier"));
        }

        public JsonElement serialize(ModifierEntry entry, Type type, JsonSerializationContext context) {
            return entry.toJson();
        }
    }
}

