/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.mining;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.mining.MiningSpeedVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record MiningSpeedFormula(ModifierFormula formula, List<MiningSpeedVariable> variables, String[] variableNames) implements VariableFormula<MiningSpeedVariable>
{
    private static final BiFunction<ModifierFormula, List<MiningSpeedVariable>, MiningSpeedFormula> CONSTRUCTOR = (formula, variables) -> new MiningSpeedFormula((ModifierFormula)formula, (List<MiningSpeedVariable>)variables, EMPTY_STRINGS);
    public static final String[] VARIABLES = new String[]{"level", "speed", "multiplier", "original_speed"};

    public MiningSpeedFormula(ModifierFormula formula, Map<String, MiningSpeedVariable> variables) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables));
    }

    @Override
    public GenericLoaderRegistry<MiningSpeedVariable> loader() {
        return MiningSpeedVariable.LOADER;
    }

    @Override
    public String[] defaultVariableNames() {
        return VARIABLES;
    }

    private float[] getArguments(IToolStackView tool, ModifierEntry modifier, @Nullable PlayerEvent.BreakSpeed event, @Nullable Player player, @Nullable Direction sideHit, float baseSpeed, float newSpeed, float multiplier) {
        int size = this.variables.size();
        float[] arguments = VariableFormula.statModuleArguments(size, this.formula.computeLevel(tool, modifier), baseSpeed, newSpeed, multiplier * tool.getMultiplier(ToolStats.MINING_SPEED));
        for (int i = 0; i < size; ++i) {
            arguments[4 + i] = this.variables.get(i).getValue(tool, event, player, sideHit);
        }
        return arguments;
    }

    public float apply(IToolStackView tool, ModifierEntry modifier, @Nullable PlayerEvent.BreakSpeed event, @Nullable Player player, @Nullable Direction sideHit, float baseSpeed, float newSpeed, float multiplier) {
        return this.formula.apply(this.getArguments(tool, modifier, event, player, sideHit, baseSpeed, newSpeed, multiplier));
    }

    public static MiningSpeedFormula deserialize(JsonObject json, boolean percent) {
        return VariableFormula.deserialize(MiningSpeedVariable.LOADER, CONSTRUCTOR, json, VARIABLES, percent ? ModifierFormula.FallbackFormula.PERCENT : ModifierFormula.FallbackFormula.BOOST);
    }

    public static MiningSpeedFormula fromNetwork(FriendlyByteBuf buffer, boolean percent) {
        return VariableFormula.fromNetwork(MiningSpeedVariable.LOADER, CONSTRUCTOR, buffer, VARIABLES.length, percent ? ModifierFormula.FallbackFormula.PERCENT : ModifierFormula.FallbackFormula.BOOST);
    }
}

