/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.melee;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.melee.MeleeVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record MeleeFormula(ModifierFormula formula, List<MeleeVariable> variables, String[] variableNames) implements VariableFormula<MeleeVariable>
{
    private static final BiFunction<ModifierFormula, List<MeleeVariable>, MeleeFormula> CONSTRUCTOR = (formula, variables) -> new MeleeFormula((ModifierFormula)formula, (List<MeleeVariable>)variables, EMPTY_STRINGS);
    public static final String[] VARIABLES = new String[]{"level", "damage", "multiplier", "base_damage"};

    public MeleeFormula(ModifierFormula formula, Map<String, MeleeVariable> variables) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables));
    }

    @Override
    public GenericLoaderRegistry<MeleeVariable> loader() {
        return MeleeVariable.LOADER;
    }

    @Override
    public String[] defaultVariableNames() {
        return VARIABLES;
    }

    private float[] getArguments(IToolStackView tool, ModifierEntry modifier, @Nullable ToolAttackContext context, @Nullable LivingEntity attacker, float baseDamage, float damage) {
        int size = this.variables.size();
        float[] arguments = VariableFormula.statModuleArguments(size, this.formula.computeLevel(tool, modifier), baseDamage, damage, tool.getMultiplier(ToolStats.ATTACK_DAMAGE));
        for (int i = 0; i < size; ++i) {
            arguments[4 + i] = this.variables.get(i).getValue(tool, context, attacker);
        }
        return arguments;
    }

    public float apply(IToolStackView tool, ModifierEntry modifier, @Nullable ToolAttackContext context, @Nullable LivingEntity attacker, float baseDamage, float damage) {
        return this.formula.apply(this.getArguments(tool, modifier, context, attacker, baseDamage, damage));
    }

    public static MeleeFormula deserialize(JsonObject json, boolean percent) {
        return VariableFormula.deserialize(MeleeVariable.LOADER, CONSTRUCTOR, json, VARIABLES, percent ? ModifierFormula.FallbackFormula.PERCENT : ModifierFormula.FallbackFormula.BOOST);
    }

    public static MeleeFormula fromNetwork(FriendlyByteBuf buffer, boolean percent) {
        return VariableFormula.fromNetwork(MeleeVariable.LOADER, CONSTRUCTOR, buffer, VARIABLES.length, percent ? ModifierFormula.FallbackFormula.PERCENT : ModifierFormula.FallbackFormula.BOOST);
    }
}

